/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.model;

import org.apache.myfaces.custom.tree.model.TreePath;

public class TreeModelEvent {
    private Object source;
    private TreePath path;
    private int[] childIndices;
    private Object[] children;

    public TreeModelEvent(Object source, Object[] path, int[] childIndices, Object[] children) {
        this(source, new TreePath(path), childIndices, children);
    }

    public TreeModelEvent(Object source, TreePath path, int[] childIndices, Object[] children) {
        this.source = source;
        this.path = path;
        this.childIndices = childIndices;
        this.children = children;
    }

    public TreeModelEvent(Object source, Object[] path) {
        this(source, new TreePath(path));
    }

    public TreeModelEvent(Object source, TreePath path) {
        this.source = source;
        this.path = path;
        this.childIndices = new int[0];
    }

    public Object getSource() {
        return this.source;
    }

    public TreePath getTreePath() {
        return this.path;
    }

    public Object[] getChildren() {
        if (this.children != null) {
            Object[] answer = new Object[this.children.length];
            System.arraycopy(this.children, 0, answer, 0, this.children.length);
            return answer;
        }
        return null;
    }

    public int[] getChildIndices() {
        if (this.childIndices != null) {
            int[] answer = new int[this.childIndices.length];
            System.arraycopy(this.childIndices, 0, answer, 0, this.childIndices.length);
            return answer;
        }
        return null;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        if (this.path != null) {
            buffer.append(" path " + this.path);
        }
        if (this.childIndices != null) {
            buffer.append(" indices [ ");
            for (i = 0; i < this.childIndices.length; ++i) {
                buffer.append(Integer.toString(this.childIndices[i]) + " ");
            }
            buffer.append("]");
        }
        if (this.children != null) {
            buffer.append(" children [ ");
            for (i = 0; i < this.children.length; ++i) {
                buffer.append(this.children[i] + " ");
            }
            buffer.append("]");
        }
        return buffer.toString();
    }
}

