/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToSymbolFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastCharToSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ak)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            char value = arg.getChar(null);
            if (value == '\u0000') {
                return SymbolConstant.NULL;
            }
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(value);
            return SymbolConstant.newInstance(Chars.toString(sink));
        }
        return new Func(arg);
    }

    private static class Func
    extends AbstractCastToSymbolFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            char value = this.arg.getChar(rec);
            if (value == '\u0000') {
                return Integer.MIN_VALUE;
            }
            return this.getInt0(value);
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            char value = this.arg.getChar(rec);
            if (value == '\u0000') {
                return null;
            }
            int keyIndex = this.symbolTableShortcut.keyIndex(value);
            if (keyIndex < 0) {
                return (CharSequence)this.symbols.getQuick(this.symbolTableShortcut.valueAt(keyIndex));
            }
            this.symbolTableShortcut.putAt(keyIndex, value, this.next++);
            this.sink.clear();
            this.sink.put(value);
            String str = Chars.toString(this.sink);
            this.symbols.add(Chars.toString(this.sink));
            return str;
        }

        @Override
        protected AbstractCastToSymbolFunction newFunc() {
            return new Func(this.arg);
        }
    }
}

