/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.tree.ITreeCursor;
import jetbrains.exodus.tree.btree.BTreeBalancePolicy;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BottomPage;
import org.jetbrains.annotations.NotNull;

public class BTreeEmpty
extends BTreeBase {
    public BTreeEmpty(@NotNull Log log, @NotNull BTreeBalancePolicy balancePolicy, boolean allowsDuplicates, int structureId) {
        super(log, balancePolicy, allowsDuplicates, structureId);
        this.size = 0L;
    }

    public BTreeEmpty(@NotNull Log log, boolean allowsDuplicates, int structureId) {
        this(log, BTreeBalancePolicy.DEFAULT, allowsDuplicates, structureId);
    }

    @Override
    @NotNull
    public BTreeMutable getMutableCopy() {
        return new BTreeMutable(this);
    }

    @Override
    public long getRootAddress() {
        return -1L;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public ITreeCursor openCursor() {
        return ITreeCursor.EMPTY_CURSOR;
    }

    @Override
    public boolean hasKey(@NotNull ByteIterable key) {
        return false;
    }

    @Override
    public boolean hasPair(@NotNull ByteIterable key, @NotNull ByteIterable value) {
        return false;
    }

    @Override
    @NotNull
    protected BasePage getRoot() {
        return new BottomPage(this);
    }
}

