/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.util;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DumpFileValidator {
    private static final Logger logger = LoggerFactory.getLogger(DumpFileValidator.class);

    private DumpFileValidator() {
    }

    public static boolean validate(String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            return DumpFileValidator.checkFileCanBeCreated(path);
        }
        catch (InvalidPathException e) {
            System.err.println("Invalid filename. The command parameters are: status-history <number of days> <dumpFile>");
            return false;
        }
    }

    private static boolean checkFileCanBeCreated(Path path) {
        try (FileOutputStream outputStream = new FileOutputStream(path.toString());){
            Closeable onClose = () -> Files.delete(path);
            Throwable throwable = null;
            if (onClose != null) {
                if (throwable != null) {
                    try {
                        onClose.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    onClose.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Invalid filename or there's no write permission to the currently selected file path.");
            return false;
        }
        catch (IOException e) {
            logger.error("Could not delete file while validating file path.");
        }
        return true;
    }
}

