/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.connect.validators;

import java.net.URI;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class ConnectHttpUrlValidator
implements ConfigDef.Validator {
    public void ensureValid(String name, Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            throw new ConfigException("Invalid value for property " + name + ": The configured value is expected to be a URL");
        }
        try {
            String protocol = URI.create((String)value).toURL().getProtocol();
            if (!protocol.equals("http") && !protocol.equals("https")) {
                throw new ConfigException("Invalid value for property " + name + ": The value must be an http or https URL");
            }
        }
        catch (Exception e) {
            throw new ConfigException("Invalid value for property " + name + ": The value is not a valid URL");
        }
    }
}

