/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.LocationType;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HeadBucketResponse
extends S3Response
implements ToCopyableBuilder<Builder, HeadBucketResponse> {
    private static final SdkField<String> BUCKET_LOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketLocationType").getter(HeadBucketResponse.getter(HeadBucketResponse::bucketLocationTypeAsString)).setter(HeadBucketResponse.setter(Builder::bucketLocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-bucket-location-type").unmarshallLocationName("x-amz-bucket-location-type").build()}).build();
    private static final SdkField<String> BUCKET_LOCATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketLocationName").getter(HeadBucketResponse.getter(HeadBucketResponse::bucketLocationName)).setter(HeadBucketResponse.setter(Builder::bucketLocationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-bucket-location-name").unmarshallLocationName("x-amz-bucket-location-name").build()}).build();
    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketRegion").getter(HeadBucketResponse.getter(HeadBucketResponse::bucketRegion)).setter(HeadBucketResponse.setter(Builder::bucketRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-bucket-region").unmarshallLocationName("x-amz-bucket-region").build()}).build();
    private static final SdkField<Boolean> ACCESS_POINT_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AccessPointAlias").getter(HeadBucketResponse.getter(HeadBucketResponse::accessPointAlias)).setter(HeadBucketResponse.setter(Builder::accessPointAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-access-point-alias").unmarshallLocationName("x-amz-access-point-alias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_LOCATION_TYPE_FIELD, BUCKET_LOCATION_NAME_FIELD, BUCKET_REGION_FIELD, ACCESS_POINT_ALIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("x-amz-bucket-location-type", BUCKET_LOCATION_TYPE_FIELD);
            this.put("x-amz-bucket-location-name", BUCKET_LOCATION_NAME_FIELD);
            this.put("x-amz-bucket-region", BUCKET_REGION_FIELD);
            this.put("x-amz-access-point-alias", ACCESS_POINT_ALIAS_FIELD);
        }
    });
    private final String bucketLocationType;
    private final String bucketLocationName;
    private final String bucketRegion;
    private final Boolean accessPointAlias;

    private HeadBucketResponse(BuilderImpl builder) {
        super(builder);
        this.bucketLocationType = builder.bucketLocationType;
        this.bucketLocationName = builder.bucketLocationName;
        this.bucketRegion = builder.bucketRegion;
        this.accessPointAlias = builder.accessPointAlias;
    }

    public final LocationType bucketLocationType() {
        return LocationType.fromValue(this.bucketLocationType);
    }

    public final String bucketLocationTypeAsString() {
        return this.bucketLocationType;
    }

    public final String bucketLocationName() {
        return this.bucketLocationName;
    }

    public final String bucketRegion() {
        return this.bucketRegion;
    }

    public final Boolean accessPointAlias() {
        return this.accessPointAlias;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketLocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPointAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeadBucketResponse)) {
            return false;
        }
        HeadBucketResponse other = (HeadBucketResponse)((Object)obj);
        return Objects.equals(this.bucketLocationTypeAsString(), other.bucketLocationTypeAsString()) && Objects.equals(this.bucketLocationName(), other.bucketLocationName()) && Objects.equals(this.bucketRegion(), other.bucketRegion()) && Objects.equals(this.accessPointAlias(), other.accessPointAlias());
    }

    public final String toString() {
        return ToString.builder((String)"HeadBucketResponse").add("BucketLocationType", (Object)this.bucketLocationTypeAsString()).add("BucketLocationName", (Object)this.bucketLocationName()).add("BucketRegion", (Object)this.bucketRegion()).add("AccessPointAlias", (Object)this.accessPointAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketLocationType": {
                return Optional.ofNullable(clazz.cast(this.bucketLocationTypeAsString()));
            }
            case "BucketLocationName": {
                return Optional.ofNullable(clazz.cast(this.bucketLocationName()));
            }
            case "BucketRegion": {
                return Optional.ofNullable(clazz.cast(this.bucketRegion()));
            }
            case "AccessPointAlias": {
                return Optional.ofNullable(clazz.cast(this.accessPointAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HeadBucketResponse, T> g) {
        return obj -> g.apply((HeadBucketResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private String bucketLocationType;
        private String bucketLocationName;
        private String bucketRegion;
        private Boolean accessPointAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(HeadBucketResponse model) {
            super(model);
            this.bucketLocationType(model.bucketLocationType);
            this.bucketLocationName(model.bucketLocationName);
            this.bucketRegion(model.bucketRegion);
            this.accessPointAlias(model.accessPointAlias);
        }

        public final String getBucketLocationType() {
            return this.bucketLocationType;
        }

        public final void setBucketLocationType(String bucketLocationType) {
            this.bucketLocationType = bucketLocationType;
        }

        @Override
        public final Builder bucketLocationType(String bucketLocationType) {
            this.bucketLocationType = bucketLocationType;
            return this;
        }

        @Override
        public final Builder bucketLocationType(LocationType bucketLocationType) {
            this.bucketLocationType(bucketLocationType == null ? null : bucketLocationType.toString());
            return this;
        }

        public final String getBucketLocationName() {
            return this.bucketLocationName;
        }

        public final void setBucketLocationName(String bucketLocationName) {
            this.bucketLocationName = bucketLocationName;
        }

        @Override
        public final Builder bucketLocationName(String bucketLocationName) {
            this.bucketLocationName = bucketLocationName;
            return this;
        }

        public final String getBucketRegion() {
            return this.bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        public final Boolean getAccessPointAlias() {
            return this.accessPointAlias;
        }

        public final void setAccessPointAlias(Boolean accessPointAlias) {
            this.accessPointAlias = accessPointAlias;
        }

        @Override
        public final Builder accessPointAlias(Boolean accessPointAlias) {
            this.accessPointAlias = accessPointAlias;
            return this;
        }

        @Override
        public HeadBucketResponse build() {
            return new HeadBucketResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, HeadBucketResponse> {
        public Builder bucketLocationType(String var1);

        public Builder bucketLocationType(LocationType var1);

        public Builder bucketLocationName(String var1);

        public Builder bucketRegion(String var1);

        public Builder accessPointAlias(Boolean var1);
    }
}

