/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.expression;

import v14.h2.engine.Session;
import v14.h2.expression.Expression;
import v14.h2.expression.ExpressionVisitor;
import v14.h2.message.DbException;
import v14.h2.schema.Sequence;
import v14.h2.table.ColumnResolver;
import v14.h2.table.TableFilter;
import v14.h2.value.TypeInfo;
import v14.h2.value.Value;

public class SequenceValue
extends Expression {
    private final Sequence sequence;
    private final boolean current;

    public SequenceValue(Sequence sequence, boolean bl) {
        this.sequence = sequence;
        this.current = bl;
    }

    @Override
    public Value getValue(Session session) {
        return this.current ? session.getCurrentValueFor(this.sequence) : this.sequence.getNext(session);
    }

    @Override
    public TypeInfo getType() {
        return this.sequence.getDatabase().getMode().decimalSequences ? TypeInfo.TYPE_DECIMAL : TypeInfo.TYPE_LONG;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(this.current ? "CURRENT" : "NEXT").append(" VALUE FOR ");
        return this.sequence.getSQL(stringBuilder, bl);
    }

    @Override
    public void updateAggregate(Session session, int n) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                return true;
            }
            case 0: 
            case 2: 
            case 8: {
                return false;
            }
            case 4: {
                expressionVisitor.addDataModificationId(this.sequence.getModificationId());
                return true;
            }
            case 7: {
                expressionVisitor.addDependency(this.sequence);
                return true;
            }
            case 5: {
                return this.current;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 1;
    }
}

