/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.flow;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ReportingTasksClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ReportingTaskResult;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;

public class GetReportingTask
extends AbstractNiFiCommand<ReportingTaskResult> {
    public GetReportingTask() {
        super("get-reporting-task", ReportingTaskResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves the status for a reporting task.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.RT_ID.createOption());
    }

    @Override
    public ReportingTaskResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String rtId = this.getRequiredArg(properties, CommandOption.RT_ID);
        ReportingTasksClient rtClient = client.getReportingTasksClient();
        ReportingTaskEntity rtEntity = rtClient.getReportingTask(rtId);
        return new ReportingTaskResult(this.getResultType(properties), rtEntity);
    }
}

