/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.reporting;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ReportingTasksClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ReportingTaskResult;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;

public class DeleteReportingTask
extends AbstractNiFiCommand<ReportingTaskResult> {
    public DeleteReportingTask() {
        super("delete-reporting-task", ReportingTaskResult.class);
    }

    @Override
    public String getDescription() {
        return "Delete a reporting task.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.RT_ID.createOption());
    }

    @Override
    public ReportingTaskResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String reportingTaskId = this.getRequiredArg(properties, CommandOption.RT_ID);
        ReportingTasksClient reportingTasksClient = client.getReportingTasksClient();
        ReportingTaskEntity reportingTask = reportingTasksClient.getReportingTask(reportingTaskId);
        ReportingTaskEntity deletedReportingTaskEntity = reportingTasksClient.deleteReportingTask(reportingTask);
        return new ReportingTaskResult(this.getResultType(properties), deletedReportingTaskEntity);
    }
}

