/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.log.BlockNotFoundException;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.DataCorruptionException;
import jetbrains.exodus.log.Log;
import org.jetbrains.annotations.NotNull;

public final class DataIterator
extends ByteIteratorWithAddress {
    @NotNull
    private final Log log;
    private final int cachePageSize;
    private final long pageAddressMask;
    private long pageAddress;
    private byte[] page;
    private int offset;
    private int length;

    public DataIterator(@NotNull Log log) {
        this(log, -1L);
    }

    public DataIterator(@NotNull Log log, long startAddress) {
        this.log = log;
        this.cachePageSize = log.getCachePageSize();
        this.pageAddressMask = (long)(this.cachePageSize - 1) ^ 0xFFFFFFFFFFFFFFFFL;
        this.pageAddress = -1L;
        if (startAddress >= 0L) {
            this.checkPageSafe(startAddress);
        }
    }

    public boolean hasNext() {
        if (this.page == null) {
            return false;
        }
        if (this.offset >= this.length) {
            this.checkPageSafe(this.getAddress());
            return this.hasNext();
        }
        return true;
    }

    public byte next() {
        if (!this.hasNext()) {
            DataCorruptionException.raise("DataIterator: no more bytes available", this.log, this.getAddress());
        }
        return this.page[this.offset++];
    }

    public long skip(long bytes) {
        long skipped;
        long pageBytesToSkip;
        for (skipped = 0L; this.page != null && skipped < bytes; skipped += pageBytesToSkip) {
            pageBytesToSkip = Math.min(bytes - skipped, (long)(this.length - this.offset));
            this.offset = (int)((long)this.offset + pageBytesToSkip);
            if (this.offset < this.length) break;
            this.checkPageSafe(this.getAddress());
        }
        return skipped;
    }

    public long nextLong(int length) {
        if (this.page == null || this.length - this.offset < length) {
            return LongBinding.entryToUnsignedLong((ByteIterator)this, (int)length);
        }
        long result = LongBinding.entryToUnsignedLong((byte[])this.page, (int)this.offset, (int)length);
        this.offset += length;
        return result;
    }

    public void checkPage(long address) {
        long pageAddress = address & this.pageAddressMask;
        if (this.pageAddress != pageAddress) {
            this.page = this.log.cache.getPage(this.log, pageAddress);
            this.pageAddress = pageAddress;
        }
        this.length = this.cachePageSize;
        this.offset = (int)(address - pageAddress);
    }

    @Override
    public long getAddress() {
        return this.pageAddress + (long)this.offset;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    private void checkPageSafe(long address) {
        try {
            this.checkPage(address);
            long pageAddress = address & this.pageAddressMask;
            this.length = (int)Math.min(this.log.getHighAddress() - pageAddress, (long)this.cachePageSize);
            if (this.length > this.offset) {
                return;
            }
        }
        catch (BlockNotFoundException blockNotFoundException) {
            // empty catch block
        }
        this.pageAddress = -1L;
        this.page = null;
    }

    @Override
    byte[] getCurrentPage() {
        return this.page;
    }

    int getLength() {
        return this.length;
    }

    @Override
    boolean availableInCurrentPage(int bytes) {
        return this.length - this.offset >= bytes;
    }
}

