/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.util.Iterator;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.NullLoggable;
import jetbrains.exodus.log.RandomAccessLoggable;
import org.jetbrains.annotations.NotNull;

public final class LoggableIterator
implements Iterator<RandomAccessLoggable> {
    @NotNull
    private final Log log;
    @NotNull
    private final ByteIteratorWithAddress it;

    public LoggableIterator(@NotNull Log log, long startAddress) {
        this(log, log.readIteratorFrom(startAddress));
    }

    public LoggableIterator(@NotNull Log log, @NotNull ByteIteratorWithAddress it) {
        this.log = log;
        this.it = it;
    }

    public long getHighAddress() {
        return this.it.getAddress();
    }

    @Override
    public RandomAccessLoggable next() {
        if (!this.hasNext()) {
            return null;
        }
        RandomAccessLoggable result = this.log.read(this.it);
        if (!NullLoggable.isNullLoggable(result)) {
            this.it.skip(result.getDataLength());
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public void remove() {
    }
}

