-- Licensed to the Apache Software Foundation (ASF) under one or more
-- contributor license agreements.  See the NOTICE file distributed with
-- this work for additional information regarding copyright ownership.
-- The ASF licenses this file to You under the Apache License, Version 2.0
-- (the "License"); you may not use this file except in compliance with
-- the License.  You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

CREATE TABLE BUNDLE (
    ID VARCHAR(50) NOT NULL,
    BUCKET_ID VARCHAR(50) NOT NULL,
    BUNDLE_TYPE VARCHAR(200) NOT NULL,
    GROUP_ID VARCHAR(200) NOT NULL,
    ARTIFACT_ID VARCHAR(200) NOT NULL,
    CONSTRAINT PK__EXTENSION_BUNDLE_ID PRIMARY KEY (ID),
    CONSTRAINT FK__EXTENSION_BUNDLE_BUCKET_ITEM_ID FOREIGN KEY (ID) REFERENCES BUCKET_ITEM(ID) ON DELETE CASCADE,
    CONSTRAINT FK__EXTENSION_BUNDLE_BUCKET_ID FOREIGN KEY(BUCKET_ID) REFERENCES BUCKET(ID) ON DELETE CASCADE,
    CONSTRAINT UNIQUE__EXTENSION_BUNDLE_BUCKET_GROUP_ARTIFACT UNIQUE (BUCKET_ID, GROUP_ID, ARTIFACT_ID)
);

CREATE TABLE BUNDLE_VERSION (
    ID VARCHAR(50) NOT NULL,
    BUNDLE_ID VARCHAR(50) NOT NULL,
    VERSION VARCHAR(100) NOT NULL,
    CREATED TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    CREATED_BY VARCHAR(767) NOT NULL,
    DESCRIPTION TEXT,
    SHA_256_HEX VARCHAR(512) NOT NULL,
    SHA_256_SUPPLIED INT NOT NULL,
    CONTENT_SIZE BIGINT NOT NULL,
    SYSTEM_API_VERSION VARCHAR(50),
    BUILD_TOOL VARCHAR(100),
    BUILD_FLAGS VARCHAR(100),
    BUILD_BRANCH VARCHAR(200),
    BUILD_TAG VARCHAR(200),
    BUILD_REVISION VARCHAR(100),
    BUILT TIMESTAMP(3) DEFAULT CURRENT_TIMESTAMP(3),
    BUILT_BY VARCHAR(767),
    CONSTRAINT PK__BUNDLE_VERSION_ID PRIMARY KEY (ID),
    CONSTRAINT FK__BUNDLE_VERSION_BUNDLE_ID FOREIGN KEY (BUNDLE_ID) REFERENCES BUNDLE(ID) ON DELETE CASCADE,
    CONSTRAINT UNIQUE__BUNDLE_VERSION_BUNDLE_ID_VERSION UNIQUE (BUNDLE_ID, VERSION)
);

CREATE TABLE BUNDLE_VERSION_DEPENDENCY (
    ID VARCHAR(50) NOT NULL,
    BUNDLE_VERSION_ID VARCHAR(50) NOT NULL,
    GROUP_ID VARCHAR(200) NOT NULL,
    ARTIFACT_ID VARCHAR(200) NOT NULL,
    VERSION VARCHAR(100) NOT NULL,
    CONSTRAINT PK__BUNDLE_VERSION_DEPENDENCY_ID PRIMARY KEY (ID),
    CONSTRAINT FK__BUNDLE_VERSION_DEPENDENCY_BUNDLE_VERSION_ID FOREIGN KEY (BUNDLE_VERSION_ID) REFERENCES BUNDLE_VERSION(ID) ON DELETE CASCADE,
    CONSTRAINT UNIQUE__BUNDLE_VERSION_DEPENDENCY_BUNDLE_ID_GAV UNIQUE (BUNDLE_VERSION_ID, GROUP_ID, ARTIFACT_ID, VERSION)
);

CREATE TABLE EXTENSION (
    ID VARCHAR(50) NOT NULL,
    BUNDLE_VERSION_ID VARCHAR(50) NOT NULL,
    NAME VARCHAR(500) NOT NULL,
    DISPLAY_NAME VARCHAR(500) NOT NULL,
    TYPE VARCHAR(100) NOT NULL,
    CONTENT TEXT NOT NULL,
    ADDITIONAL_DETAILS TEXT,
    HAS_ADDITIONAL_DETAILS INT NOT NULL,
    CONSTRAINT PK__EXTENSION_ID PRIMARY KEY (ID),
    CONSTRAINT FK__EXTENSION_BUNDLE_VERSION_ID FOREIGN KEY (BUNDLE_VERSION_ID) REFERENCES BUNDLE_VERSION(ID) ON DELETE CASCADE,
    CONSTRAINT UNIQUE__EXTENSION_BUNDLE_VERSION_ID_AND_NAME UNIQUE (BUNDLE_VERSION_ID, NAME)
);

CREATE TABLE EXTENSION_PROVIDED_SERVICE_API (
    ID VARCHAR(50) NOT NULL,
    EXTENSION_ID VARCHAR(50) NOT NULL,
    CLASS_NAME VARCHAR (200) NOT NULL,
    GROUP_ID VARCHAR(200) NOT NULL,
    ARTIFACT_ID VARCHAR(200) NOT NULL,
    VERSION VARCHAR(100) NOT NULL,
    CONSTRAINT PK__EXTENSION_PROVIDED_SERVICE_API_ID PRIMARY KEY (ID),
    CONSTRAINT FK__EXTENSION_PROVIDED_SERVICE_API_EXTENSION_ID FOREIGN KEY (EXTENSION_ID) REFERENCES EXTENSION(ID) ON DELETE CASCADE,
    CONSTRAINT UNIQUE__EXTENSION_PROVIDED_SERVICE_API UNIQUE (EXTENSION_ID, CLASS_NAME, GROUP_ID, ARTIFACT_ID, VERSION)
);

CREATE TABLE EXTENSION_RESTRICTION (
    ID VARCHAR(50) NOT NULL,
    EXTENSION_ID VARCHAR(50) NOT NULL,
    REQUIRED_PERMISSION VARCHAR(200) NOT NULL,
    EXPLANATION VARCHAR (4096) NOT NULL,
    CONSTRAINT PK__EXTENSION_RESTRICTION_ID PRIMARY KEY (ID),
    CONSTRAINT FK__EXTENSION_RESTRICTION_EXTENSION_ID FOREIGN KEY (EXTENSION_ID) REFERENCES EXTENSION(ID) ON DELETE CASCADE,
    CONSTRAINT UNIQUE__EXTENSION_RESTRICTION_EXTENSION_ID_REQUIRED_PERMISSION UNIQUE (EXTENSION_ID, REQUIRED_PERMISSION)
);

CREATE TABLE EXTENSION_TAG (
    EXTENSION_ID VARCHAR(50) NOT NULL,
    TAG VARCHAR(200) NOT NULL,
    CONSTRAINT PK__EXTENSION_TAG_EXTENSION_ID_AND_TAG PRIMARY KEY (EXTENSION_ID, TAG),
    CONSTRAINT FK__EXTENSION_TAG_EXTENSION_ID FOREIGN KEY (EXTENSION_ID) REFERENCES EXTENSION(ID) ON DELETE CASCADE
);

ALTER TABLE BUCKET ADD ALLOW_EXTENSION_BUNDLE_REDEPLOY INT NOT NULL DEFAULT 0;