/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowfile.attributes;

import java.util.HashMap;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.FlowFileAttributeKey;
import org.apache.nifi.processor.ProcessSession;

public enum FragmentAttributes implements FlowFileAttributeKey
{
    FRAGMENT_SIZE("fragment.size"),
    FRAGMENT_ID("fragment.identifier"),
    FRAGMENT_INDEX("fragment.index"),
    FRAGMENT_COUNT("fragment.count"),
    SEGMENT_ORIGINAL_FILENAME("segment.original.filename");

    private final String key;

    private FragmentAttributes(String key) {
        this.key = key;
    }

    public String key() {
        return this.key;
    }

    public static FlowFile copyAttributesToOriginal(ProcessSession processSession, FlowFile originalFlowFile, String fragmentId, int fragmentCount) {
        HashMap<String, String> attributesToOriginal = new HashMap<String, String>();
        if (fragmentId != null && fragmentId.length() > 0) {
            attributesToOriginal.put(FRAGMENT_ID.key(), fragmentId);
        }
        attributesToOriginal.put(FRAGMENT_COUNT.key(), String.valueOf(fragmentCount));
        return processSession.putAllAttributes(originalFlowFile, attributesToOriginal);
    }
}

