/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BootstrapClassLoaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BootstrapClassLoaderUtils.class);
    private static final String LIB_BOOTSTRAP_DIR = "lib/bootstrap";

    private BootstrapClassLoaderUtils() {
    }

    public static ClassLoader createBootstrapClassLoader() {
        ArrayList urls = new ArrayList();
        try (Stream<Path> files = Files.list(Paths.get(LIB_BOOTSTRAP_DIR, new String[0]));){
            files.forEach(p -> {
                try {
                    urls.add(p.toUri().toURL());
                }
                catch (MalformedURLException mef) {
                    LOGGER.warn("Unable to load bootstrap library [{}]", (Object)p.getFileName(), (Object)mef);
                }
            });
        }
        catch (IOException ioe) {
            LOGGER.warn("Unable to access lib/bootstrap to create bootstrap classloader", (Throwable)ioe);
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }
}

