/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.registry.BootstrapListener;
import org.apache.nifi.registry.jetty.JettyServer;
import org.apache.nifi.registry.jetty.handler.HandlerProvider;
import org.apache.nifi.registry.jetty.handler.StandardHandlerProvider;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class NiFiRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(NiFiRegistry.class);
    public static final String BOOTSTRAP_PORT_PROPERTY = "nifi.registry.bootstrap.listen.port";
    public static final String SECURITY_KRB5_CONF_PROPERTY = "java.security.krb5.conf";
    private final JettyServer server;
    private final BootstrapListener bootstrapListener;
    private volatile boolean shutdown = false;

    public NiFiRegistry(NiFiRegistryProperties properties) throws IOException, IllegalArgumentException {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOGGER.error("An Unknown Error Occurred in Thread {}", (Object)t, (Object)e));
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdownHook));
        String bootstrapPort = System.getProperty(BOOTSTRAP_PORT_PROPERTY);
        if (bootstrapPort != null) {
            try {
                int port = Integer.parseInt(bootstrapPort);
                if (port < 1 || port > 65535) {
                    throw new RuntimeException("Failed to start NiFi Registry because system property 'nifi.registry.bootstrap.listen.port' is not a valid integer in the range 1 - 65535");
                }
                this.bootstrapListener = new BootstrapListener(this, port);
                this.bootstrapListener.start();
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("Failed to start NiFi Registry because system property 'nifi.registry.bootstrap.listen.port' is not a valid integer in the range 1 - 65535");
            }
        } else {
            LOGGER.info("NiFi Registry started without Bootstrap Port information provided; will not listen for requests from Bootstrap");
            this.bootstrapListener = null;
        }
        File webWorkingDir = properties.getWebWorkingDirectory();
        FileUtils.deleteFilesInDirectory((File)webWorkingDir, null, (Logger)LOGGER, (boolean)true, (boolean)true);
        FileUtils.deleteFile((File)webWorkingDir, (Logger)LOGGER, (int)3);
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        this.setKerberosConfiguration(properties);
        long startTime = System.nanoTime();
        String docsDirectory = System.getProperty("nifi.registry.bootstrap.config.docs.dir", "docs");
        StandardHandlerProvider handlerProvider = new StandardHandlerProvider(docsDirectory);
        this.server = new JettyServer(properties, (HandlerProvider)handlerProvider);
        if (this.shutdown) {
            LOGGER.info("NiFi Registry has been shutdown via NiFi Registry Bootstrap. Will not start Controller");
        } else {
            this.server.start();
            if (this.bootstrapListener != null) {
                this.bootstrapListener.sendStartedStatus(true);
            }
            long duration = System.nanoTime() - startTime;
            double durationSeconds = (double)TimeUnit.NANOSECONDS.toMillis(duration) / 1000.0;
            LOGGER.info("Started Application in {} seconds ({} ns)", (Object)durationSeconds, (Object)duration);
        }
    }

    protected void shutdownHook() {
        try {
            this.shutdown = true;
            LOGGER.info("Initiating shutdown of Jetty web server...");
            if (this.server != null) {
                this.server.stop();
            }
            if (this.bootstrapListener != null) {
                this.bootstrapListener.stop();
            }
            LOGGER.info("Jetty web server shutdown completed (nicely or otherwise).");
        }
        catch (Throwable t) {
            LOGGER.warn("Problem occurred ensuring Jetty web server was properly terminated", t);
        }
    }

    private void setKerberosConfiguration(NiFiRegistryProperties properties) {
        File kerberosConfigFile = properties.getKerberosConfigurationFile();
        if (kerberosConfigFile == null) {
            LOGGER.debug("NiFi Registry Kerberos Configuration not specified");
        } else {
            String kerberosConfigFilePath = kerberosConfigFile.getAbsolutePath();
            LOGGER.info("Using Kerberos configuration file defined at {}", (Object)kerberosConfigFilePath);
            System.setProperty(SECURITY_KRB5_CONF_PROPERTY, kerberosConfigFilePath);
        }
    }

    public static void main(String[] args) {
        LOGGER.info("Launching NiFi Registry...");
        try {
            new NiFiRegistry(NiFiRegistry.initializeProperties());
        }
        catch (Throwable t) {
            LOGGER.error("Failure to launch NiFi Registry", t);
        }
    }

    public static NiFiRegistryProperties initializeProperties() {
        String nifiRegistryPropertiesFilePath = System.getProperty("nifi.registry.properties.file.path", "conf/nifi-registry.properties");
        try {
            Class<?> propsLoaderClass = Class.forName("org.apache.nifi.registry.properties.NiFiRegistryPropertiesLoader");
            Object loaderInstance = propsLoaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method loadMethod = propsLoaderClass.getMethod("load", String.class);
            NiFiRegistryProperties properties = (NiFiRegistryProperties)loadMethod.invoke(loaderInstance, nifiRegistryPropertiesFilePath);
            LOGGER.info("Application Properties loaded [{}]", (Object)properties.size());
            return properties;
        }
        catch (InstantiationException | InvocationTargetException wrappedException) {
            String msg = "There was an issue decrypting protected properties";
            throw new IllegalArgumentException("There was an issue decrypting protected properties", wrappedException.getCause() == null ? wrappedException : wrappedException.getCause());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            String msg = "Unable to access properties loader in the expected manner - apparent classpath or build issue";
            throw new IllegalArgumentException("Unable to access properties loader in the expected manner - apparent classpath or build issue", e);
        }
        catch (RuntimeException e) {
            String msg = "There was an issue decrypting protected properties";
            throw new IllegalArgumentException("There was an issue decrypting protected properties", e);
        }
    }
}

