/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.math.BigInteger;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;

public class GCDFunction
extends FunctionN {
    public static final int GCD = 0;
    public static final int LCM = 1;
    private static final String[] NAMES = new String[]{"GCD", "LCM"};
    public static final int MAX_BIT_LENGTH = (int)Math.ceil(100000.0 / Math.log10(2.0));
    private final int function;

    public GCDFunction(int n) {
        super(new Expression[2]);
        this.function = n;
        this.type = TypeInfo.TYPE_NUMERIC_SCALE_0;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        Value value = this.args[0].getValue(sessionLocal);
        if (value == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        Value value2 = this.args[1].getValue(sessionLocal);
        if (value2 == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        BigInteger bigInteger = value.getBigInteger();
        BigInteger bigInteger2 = value2.getBigInteger();
        switch (this.function) {
            case 0: {
                return this.gcd(sessionLocal, bigInteger, bigInteger2);
            }
            case 1: {
                return this.lcm(sessionLocal, bigInteger, bigInteger2);
            }
        }
        throw DbException.getInternalError("function=" + this.function);
    }

    private Value gcd(SessionLocal sessionLocal, BigInteger bigInteger, BigInteger bigInteger2) {
        bigInteger = bigInteger.gcd(bigInteger2);
        int n = this.args.length;
        if (n > 2) {
            boolean bl = bigInteger.equals(BigInteger.ONE);
            for (int i = 2; i < n; ++i) {
                Value value = this.args[i].getValue(sessionLocal);
                if (value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                if (bl || (bigInteger2 = value.getBigInteger()).signum() == 0) continue;
                bigInteger = bigInteger.gcd(bigInteger2);
                bl = bigInteger.equals(BigInteger.ONE);
            }
        }
        return ValueNumeric.get(bigInteger);
    }

    private Value lcm(SessionLocal sessionLocal, BigInteger bigInteger, BigInteger bigInteger2) {
        boolean bl = bigInteger.signum() == 0 || bigInteger2.signum() == 0;
        bigInteger = bl ? BigInteger.ZERO : bigInteger.multiply(bigInteger2).abs().divide(bigInteger.gcd(bigInteger2));
        int n = this.args.length;
        if (n > 2) {
            boolean bl2 = !bl && bigInteger.bitLength() > MAX_BIT_LENGTH;
            for (int i = 2; i < n; ++i) {
                Value value = this.args[i].getValue(sessionLocal);
                if (value == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                if (bl) continue;
                bigInteger2 = value.getBigInteger();
                if (bigInteger2.signum() == 0) {
                    bigInteger = BigInteger.ZERO;
                    bl = true;
                    bl2 = false;
                    continue;
                }
                if (bl2) continue;
                bl2 = (bigInteger = bigInteger.multiply(bigInteger2).abs().divide(bigInteger.gcd(bigInteger2))).bitLength() > MAX_BIT_LENGTH;
            }
            if (bl2) {
                throw DbException.getValueTooLongException("NUMERIC", "unknown least common multiple", -1L);
            }
        }
        return ValueNumeric.get(bigInteger);
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        boolean bl = true;
        boolean bl2 = false;
        int n = this.args.length;
        for (int i = 0; i < n; ++i) {
            Expression expression2 = this.args[i].optimize(sessionLocal);
            bl2 |= GCDFunction.checkType(expression2, this.getName());
            this.args[i] = expression2;
            if (!bl || expression2.isConstant()) continue;
            bl = false;
        }
        if (bl) {
            return TypedValueExpression.getTypedIfNull(this.getValue(sessionLocal), TypeInfo.TYPE_NUMERIC_SCALE_0);
        }
        if (bl2) {
            return TypedValueExpression.get(ValueNull.INSTANCE, TypeInfo.TYPE_NUMERIC_SCALE_0);
        }
        this.inlineSubexpressions(expression -> expression instanceof GCDFunction && ((GCDFunction)expression).function == this.function);
        return this;
    }

    public static boolean checkType(Expression expression, String string) {
        TypeInfo typeInfo = expression.getType();
        switch (typeInfo.getValueType()) {
            case 0: {
                return true;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                if (typeInfo.getScale() == 0) break;
            }
            default: {
                throw DbException.getInvalidValueException(string + " argument", expression.getTraceSQL());
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

