/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.ChunkExtensionProvider;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.ChunkedEncodedInputStream;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.ChunkedEncodedPayload;
import software.amazon.awssdk.http.auth.aws.internal.signer.chunkedencoding.TrailerProvider;
import software.amazon.awssdk.http.auth.aws.internal.signer.io.ChecksumInputStream;

@SdkInternalApi
public class SyncChunkEncodedPayload
implements ChunkedEncodedPayload {
    private final ChunkedEncodedInputStream.Builder chunkedInputStream;

    public SyncChunkEncodedPayload(ChunkedEncodedInputStream.Builder chunkedInputStream) {
        this.chunkedInputStream = chunkedInputStream;
    }

    @Override
    public void addTrailer(TrailerProvider trailerProvider) {
        this.chunkedInputStream.addTrailer(trailerProvider);
    }

    @Override
    public List<TrailerProvider> trailers() {
        return this.chunkedInputStream.trailers();
    }

    @Override
    public void addExtension(ChunkExtensionProvider chunkExtensionProvider) {
        this.chunkedInputStream.addExtension(chunkExtensionProvider);
    }

    @Override
    public void checksumPayload(SdkChecksum checksum) {
        ChecksumInputStream checksumInputStream = new ChecksumInputStream(this.chunkedInputStream.inputStream(), Collections.singleton(checksum));
        this.chunkedInputStream.inputStream(checksumInputStream);
    }
}

