/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidURIRule
extends Rule {
    private static final Logger LOG = LoggerFactory.getLogger(InvalidURIRule.class);
    private static final int REPLACEMENT_CHAR_CODEPOINT = 65533;
    private int _code = 400;
    private String _message = "Illegal URI";

    @Override
    public boolean isTerminating() {
        return true;
    }

    public int getCode() {
        return this._code;
    }

    public void setCode(int code) {
        this._code = code;
    }

    public String getMessage() {
        return this._message;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        int codepoint;
        String path = input.getHttpURI().getDecodedPath();
        for (int i = 0; i < path.length(); i += Character.charCount(codepoint)) {
            codepoint = path.codePointAt(i);
            if (this.isValidChar(codepoint)) continue;
            return this.apply(input);
        }
        return null;
    }

    private Rule.Handler apply(Rule.Handler input) {
        return new Rule.Handler(input){

            @Override
            protected boolean handle(Response response, Callback callback) {
                String message = InvalidURIRule.this.getMessage();
                if (StringUtil.isBlank((String)message)) {
                    response.setStatus(InvalidURIRule.this.getCode());
                    callback.succeeded();
                } else {
                    Response.writeError((Request)this, (Response)response, (Callback)callback, (int)InvalidURIRule.this.getCode(), (String)message);
                }
                return true;
            }
        };
    }

    protected boolean isValidChar(int codepoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codepoint);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} {} {}", new Object[]{Character.charCount(codepoint), codepoint, block, Character.isISOControl(codepoint)});
        }
        if (codepoint == 65533) {
            return false;
        }
        return !Character.isISOControl(codepoint) && block != null && !Character.UnicodeBlock.SPECIALS.equals(block);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._code + ":" + this._message + "]";
    }
}

