/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.http;

import com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.archive.format.http.HttpHeader;
import org.archive.format.http.HttpRequest;
import org.archive.resource.AbstractResource;
import org.archive.resource.MetaData;
import org.archive.resource.ResourceConstants;
import org.archive.resource.ResourceContainer;
import org.archive.util.Base32;
import org.archive.util.StreamCopy;
import org.archive.util.io.EOFNotifyingInputStream;
import org.archive.util.io.EOFObserver;

public class HTTPRequestResource
extends AbstractResource
implements ResourceConstants,
EOFObserver {
    CountingInputStream countingIS;
    private HttpRequest request;
    DigestInputStream digIS;

    public HTTPRequestResource(MetaData metaData, ResourceContainer container, HttpRequest request) {
        this(metaData, container, request, false);
    }

    public HTTPRequestResource(MetaData metaData, ResourceContainer container, HttpRequest request, boolean forceCheck) {
        super(metaData, container);
        this.request = request;
        MetaData message = metaData.createChild("Request-Message");
        message.putString("Method", request.getMessage().getMethodString());
        message.putString("Path", request.getMessage().getPath());
        message.putString("Version", request.getMessage().getVersionString());
        metaData.putLong("Headers-Length", request.getHeaderBytes());
        if (request.getHeaders().isCorrupt()) {
            metaData.putBoolean("Headers-Corrupt", true);
        }
        MetaData headers = metaData.createChild("Headers");
        for (HttpHeader h : request.getHeaders()) {
            headers.putString(h.getName(), h.getValue());
        }
        this.countingIS = new CountingInputStream((InputStream)request);
        try {
            this.digIS = new DigestInputStream((InputStream)this.countingIS, MessageDigest.getInstance("sha1"));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public HttpRequest getHttpResponse() {
        return this.request;
    }

    @Override
    public InputStream getInputStream() {
        return new EOFNotifyingInputStream(this.digIS, this);
    }

    @Override
    public void notifyEOF() throws IOException {
        this.metaData.putLong("Entity-Length", this.countingIS.getCount());
        String digString = Base32.encode(this.digIS.getMessageDigest().digest());
        this.metaData.putString("Entity-Digest", "sha1:" + digString);
        this.metaData.putLong("Entity-Trailing-Slop-Length", StreamCopy.readToEOF(this.request));
    }
}

