/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.nutch.crawl.SignatureComparator;
import org.apache.nutch.protocol.ProtocolStatus;
import org.apache.nutch.util.StringUtil;

public class CrawlDatum
implements WritableComparable<CrawlDatum>,
Cloneable {
    public static final String GENERATE_DIR_NAME = "crawl_generate";
    public static final String FETCH_DIR_NAME = "crawl_fetch";
    public static final String PARSE_DIR_NAME = "crawl_parse";
    private static final byte CUR_VERSION = 7;
    private static final byte OLD_STATUS_SIGNATURE = 0;
    private static final byte OLD_STATUS_DB_UNFETCHED = 1;
    private static final byte OLD_STATUS_DB_FETCHED = 2;
    private static final byte OLD_STATUS_DB_GONE = 3;
    private static final byte OLD_STATUS_LINKED = 4;
    private static final byte OLD_STATUS_FETCH_SUCCESS = 5;
    private static final byte OLD_STATUS_FETCH_RETRY = 6;
    private static final byte OLD_STATUS_FETCH_GONE = 7;
    private static HashMap<Byte, Byte> oldToNew = new HashMap();
    public static final byte STATUS_DB_UNFETCHED = 1;
    public static final byte STATUS_DB_FETCHED = 2;
    public static final byte STATUS_DB_GONE = 3;
    public static final byte STATUS_DB_REDIR_TEMP = 4;
    public static final byte STATUS_DB_REDIR_PERM = 5;
    public static final byte STATUS_DB_NOTMODIFIED = 6;
    public static final byte STATUS_DB_DUPLICATE = 7;
    public static final byte STATUS_DB_ORPHAN = 8;
    public static final byte STATUS_DB_MAX = 31;
    public static final byte STATUS_FETCH_SUCCESS = 33;
    public static final byte STATUS_FETCH_RETRY = 34;
    public static final byte STATUS_FETCH_REDIR_TEMP = 35;
    public static final byte STATUS_FETCH_REDIR_PERM = 36;
    public static final byte STATUS_FETCH_GONE = 37;
    public static final byte STATUS_FETCH_NOTMODIFIED = 38;
    public static final byte STATUS_FETCH_MAX = 63;
    public static final byte STATUS_SIGNATURE = 65;
    public static final byte STATUS_INJECTED = 66;
    public static final byte STATUS_LINKED = 67;
    public static final byte STATUS_PARSE_META = 68;
    public static final HashMap<Byte, String> statNames = new HashMap();
    private byte status;
    private long fetchTime = System.currentTimeMillis();
    private byte retries;
    private int fetchInterval;
    private float score = 0.0f;
    private byte[] signature = null;
    private long modifiedTime;
    private MapWritable metaData;
    private static final int SCORE_OFFSET = 15;
    private static final int SIG_OFFSET = 27;

    public static boolean hasDbStatus(CrawlDatum datum) {
        return datum.status <= 31;
    }

    public static boolean hasFetchStatus(CrawlDatum datum) {
        return datum.status > 31 && datum.status <= 63;
    }

    public CrawlDatum() {
    }

    public CrawlDatum(int status, int fetchInterval) {
        this();
        this.status = (byte)status;
        this.fetchInterval = fetchInterval;
    }

    public CrawlDatum(int status, int fetchInterval, float score) {
        this(status, fetchInterval);
        this.score = score;
    }

    public byte getStatus() {
        return this.status;
    }

    public static String getStatusName(byte value) {
        String res = statNames.get(value);
        if (res == null) {
            res = "unknown";
        }
        return res;
    }

    public static byte getStatusByName(String name) {
        for (Map.Entry<Byte, String> status : statNames.entrySet()) {
            if (!name.equalsIgnoreCase(status.getValue())) continue;
            return status.getKey();
        }
        return -1;
    }

    public void setStatus(int status) {
        this.status = (byte)status;
    }

    public long getFetchTime() {
        return this.fetchTime;
    }

    public void setFetchTime(long fetchTime) {
        this.fetchTime = fetchTime;
    }

    public long getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(long modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public byte getRetriesSinceFetch() {
        return this.retries;
    }

    public void setRetriesSinceFetch(int retries) {
        this.retries = (byte)retries;
    }

    public int getFetchInterval() {
        return this.fetchInterval;
    }

    public void setFetchInterval(int fetchInterval) {
        this.fetchInterval = fetchInterval;
    }

    public void setFetchInterval(float fetchInterval) {
        this.fetchInterval = Math.round(fetchInterval);
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        if (signature != null && signature.length > 256) {
            throw new RuntimeException("Max signature length (256) exceeded: " + signature.length);
        }
        this.signature = signature;
    }

    public void setMetaData(MapWritable mapWritable) {
        this.metaData = new MapWritable(mapWritable);
    }

    public void putAllMetaData(CrawlDatum other) {
        for (Map.Entry e : other.getMetaData().entrySet()) {
            this.getMetaData().put((Writable)e.getKey(), (Writable)e.getValue());
        }
    }

    public MapWritable getMetaData() {
        if (this.metaData == null) {
            this.metaData = new MapWritable();
        }
        return this.metaData;
    }

    public static CrawlDatum read(DataInput in) throws IOException {
        CrawlDatum result = new CrawlDatum();
        result.readFields(in);
        return result;
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 7) {
            throw new VersionMismatchException(7, version);
        }
        this.status = in.readByte();
        this.fetchTime = in.readLong();
        this.retries = in.readByte();
        this.fetchInterval = version > 5 ? in.readInt() : Math.round(in.readFloat());
        this.score = in.readFloat();
        if (version > 2) {
            this.modifiedTime = in.readLong();
            byte cnt = in.readByte();
            if (cnt > 0) {
                this.signature = new byte[cnt];
                in.readFully(this.signature);
            } else {
                this.signature = null;
            }
        }
        if (version > 3) {
            boolean hasMetadata = false;
            if (version < 7) {
                MapWritable oldMetaData = new MapWritable();
                if (in.readBoolean()) {
                    hasMetadata = true;
                    this.metaData = new MapWritable();
                    oldMetaData.readFields(in);
                }
                for (Writable key : oldMetaData.keySet()) {
                    this.metaData.put(key, oldMetaData.get((Object)key));
                }
            } else if (in.readBoolean()) {
                hasMetadata = true;
                this.metaData = new MapWritable();
                this.metaData.readFields(in);
            }
            if (!hasMetadata) {
                this.metaData = null;
            }
        }
        if (version < 5) {
            this.status = oldToNew.containsKey(this.status) ? oldToNew.get(this.status) : (byte)1;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(7);
        out.writeByte(this.status);
        out.writeLong(this.fetchTime);
        out.writeByte(this.retries);
        out.writeInt(this.fetchInterval);
        out.writeFloat(this.score);
        out.writeLong(this.modifiedTime);
        if (this.signature == null) {
            out.writeByte(0);
        } else {
            out.writeByte(this.signature.length);
            out.write(this.signature);
        }
        if (this.metaData != null && this.metaData.size() > 0) {
            out.writeBoolean(true);
            this.metaData.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void set(CrawlDatum that) {
        this.status = that.status;
        this.fetchTime = that.fetchTime;
        this.retries = that.retries;
        this.fetchInterval = that.fetchInterval;
        this.score = that.score;
        this.modifiedTime = that.modifiedTime;
        this.signature = that.signature;
        this.metaData = that.metaData != null ? new MapWritable(that.metaData) : null;
    }

    public int compareTo(CrawlDatum that) {
        if (that.score != this.score) {
            return that.score - this.score > 0.0f ? 1 : -1;
        }
        if (that.status != this.status) {
            return this.status - that.status;
        }
        if (that.fetchTime != this.fetchTime) {
            return that.fetchTime - this.fetchTime > 0L ? 1 : -1;
        }
        if (that.retries != this.retries) {
            return that.retries - this.retries;
        }
        if (that.fetchInterval != this.fetchInterval) {
            return that.fetchInterval - this.fetchInterval > 0 ? 1 : -1;
        }
        if (that.modifiedTime != this.modifiedTime) {
            return that.modifiedTime - this.modifiedTime > 0L ? 1 : -1;
        }
        return SignatureComparator._compare(this, that);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Version: 7\n");
        buf.append("Status: " + this.getStatus() + " (" + CrawlDatum.getStatusName(this.getStatus()) + ")\n");
        buf.append("Fetch time: " + String.valueOf(new Date(this.getFetchTime())) + "\n");
        buf.append("Modified time: " + String.valueOf(new Date(this.getModifiedTime())) + "\n");
        buf.append("Retries since fetch: " + this.getRetriesSinceFetch() + "\n");
        buf.append("Retry interval: " + this.getFetchInterval() + " seconds (" + this.getFetchInterval() / 86400 + " days)\n");
        buf.append("Score: " + this.getScore() + "\n");
        buf.append("Signature: " + StringUtil.toHexString(this.getSignature()) + "\n");
        buf.append("Metadata: \n ");
        if (this.metaData != null) {
            for (Map.Entry e : this.metaData.entrySet()) {
                buf.append("\t");
                buf.append(e.getKey());
                buf.append("=");
                buf.append(e.getValue());
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    private boolean metadataEquals(MapWritable otherMetaData) {
        if (this.metaData == null || this.metaData.size() == 0) {
            return otherMetaData == null || otherMetaData.size() == 0;
        }
        if (otherMetaData == null) {
            return false;
        }
        HashSet set1 = new HashSet(this.metaData.entrySet());
        HashSet set2 = new HashSet(otherMetaData.entrySet());
        return set1.equals(set2);
    }

    public boolean equals(Object o) {
        boolean res;
        if (!(o instanceof CrawlDatum)) {
            return false;
        }
        CrawlDatum other = (CrawlDatum)o;
        boolean bl = res = this.status == other.status && this.fetchTime == other.fetchTime && this.modifiedTime == other.modifiedTime && this.retries == other.retries && this.fetchInterval == other.fetchInterval && SignatureComparator._compare(this.signature, other.signature) == 0 && this.score == other.score;
        if (!res) {
            return res;
        }
        return this.metadataEquals(other.metaData);
    }

    public int hashCode() {
        int res = 0;
        if (this.signature != null) {
            for (int i = 0; i < this.signature.length / 4; i += 4) {
                res ^= (this.signature[i] << 24) + (this.signature[i + 1] << 16) + (this.signature[i + 2] << 8) + this.signature[i + 3];
            }
        }
        if (this.metaData != null) {
            res ^= this.metaData.entrySet().hashCode();
        }
        return res ^ this.status ^ (int)this.fetchTime ^ (int)this.modifiedTime ^ this.retries ^ this.fetchInterval ^ Float.floatToIntBits(this.score);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean execute(JexlScript expr, String url) {
        if (expr != null && url != null) {
            MapContext jcontext = new MapContext();
            jcontext.set("url", (Object)url);
            jcontext.set("status", (Object)CrawlDatum.getStatusName(this.getStatus()));
            jcontext.set("fetchTime", (Object)this.getFetchTime());
            jcontext.set("modifiedTime", (Object)this.getModifiedTime());
            jcontext.set("retries", (Object)this.getRetriesSinceFetch());
            jcontext.set("interval", (Object)this.getFetchInterval());
            jcontext.set("score", (Object)Float.valueOf(this.getScore()));
            jcontext.set("signature", (Object)StringUtil.toHexString(this.getSignature()));
            for (Map.Entry entry : this.getMetaData().entrySet()) {
                Object value = entry.getValue();
                Text tkey = (Text)entry.getKey();
                if (value instanceof FloatWritable) {
                    FloatWritable fvalue = (FloatWritable)value;
                    jcontext.set(tkey.toString(), (Object)Float.valueOf(fvalue.get()));
                }
                if (value instanceof IntWritable) {
                    IntWritable ivalue = (IntWritable)value;
                    jcontext.set(tkey.toString(), (Object)ivalue.get());
                }
                if (value instanceof Text) {
                    Text tvalue = (Text)value;
                    jcontext.set(tkey.toString().replace("-", "_"), (Object)tvalue.toString());
                }
                if (!(value instanceof ProtocolStatus)) continue;
                ProtocolStatus pvalue = (ProtocolStatus)value;
                jcontext.set(tkey.toString().replace("-", "_"), (Object)pvalue.toString());
            }
            try {
                if (Boolean.TRUE.equals(expr.execute((JexlContext)jcontext))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    static {
        statNames.put((byte)1, "db_unfetched");
        statNames.put((byte)2, "db_fetched");
        statNames.put((byte)3, "db_gone");
        statNames.put((byte)4, "db_redir_temp");
        statNames.put((byte)5, "db_redir_perm");
        statNames.put((byte)6, "db_notmodified");
        statNames.put((byte)7, "db_duplicate");
        statNames.put((byte)8, "db_orphan");
        statNames.put((byte)65, "signature");
        statNames.put((byte)66, "injected");
        statNames.put((byte)67, "linked");
        statNames.put((byte)33, "fetch_success");
        statNames.put((byte)34, "fetch_retry");
        statNames.put((byte)35, "fetch_redir_temp");
        statNames.put((byte)36, "fetch_redir_perm");
        statNames.put((byte)37, "fetch_gone");
        statNames.put((byte)38, "fetch_notmodified");
        statNames.put((byte)68, "parse_metadata");
        oldToNew.put((byte)1, (byte)1);
        oldToNew.put((byte)2, (byte)2);
        oldToNew.put((byte)3, (byte)3);
        oldToNew.put((byte)7, (byte)37);
        oldToNew.put((byte)5, (byte)33);
        oldToNew.put((byte)6, (byte)34);
        oldToNew.put((byte)4, (byte)67);
        oldToNew.put((byte)0, (byte)65);
        WritableComparator.define(CrawlDatum.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(CrawlDatum.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            float score1 = Comparator.readFloat((byte[])b1, (int)(s1 + 15));
            float score2 = Comparator.readFloat((byte[])b2, (int)(s2 + 15));
            if (score2 != score1) {
                return score2 - score1 > 0.0f ? 1 : -1;
            }
            byte status2 = b2[s2 + 1];
            byte status1 = b1[s1 + 1];
            if (status2 != status1) {
                return status1 - status2;
            }
            long fetchTime1 = Comparator.readLong((byte[])b1, (int)(s1 + 2));
            long fetchTime2 = Comparator.readLong((byte[])b2, (int)(s2 + 2));
            if (fetchTime2 != fetchTime1) {
                return fetchTime2 - fetchTime1 > 0L ? 1 : -1;
            }
            byte retries2 = b2[s2 + 10];
            byte retries1 = b1[s1 + 10];
            if (retries2 != retries1) {
                return retries2 - retries1;
            }
            int fetchInterval1 = Comparator.readInt((byte[])b1, (int)(s1 + 11));
            int fetchInterval2 = Comparator.readInt((byte[])b2, (int)(s2 + 11));
            if (fetchInterval2 != fetchInterval1) {
                return fetchInterval2 - fetchInterval1 > 0 ? 1 : -1;
            }
            long modifiedTime1 = Comparator.readLong((byte[])b1, (int)(s1 + 15 + 4));
            long modifiedTime2 = Comparator.readLong((byte[])b2, (int)(s2 + 15 + 4));
            if (modifiedTime2 != modifiedTime1) {
                return modifiedTime2 - modifiedTime1 > 0L ? 1 : -1;
            }
            byte sigl1 = b1[s1 + 27];
            byte sigl2 = b2[s2 + 27];
            return SignatureComparator._compare(b1, 27, sigl1, b2, 27, sigl2);
        }
    }
}

