/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import de.vandermeer.asciitable.AT_Cell;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.skb.interfaces.document.TableRowType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.exchange.Exchanges;
import org.apache.nutch.indexer.IndexWriter;
import org.apache.nutch.indexer.IndexWriterConfig;
import org.apache.nutch.indexer.MappingReader;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.indexer.NutchField;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IndexWriters {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final WeakHashMap<String, IndexWriters> CACHE = new WeakHashMap();
    private HashMap<String, IndexWriterWrapper> indexWriters;
    private Exchanges exchanges;

    public static synchronized IndexWriters get(Configuration conf) {
        Object uuid = NutchConfiguration.getUUID(conf);
        if (uuid == null) {
            uuid = "nonNutchConf@" + conf.hashCode();
        }
        return CACHE.computeIfAbsent((String)uuid, k -> new IndexWriters(conf));
    }

    private IndexWriters(Configuration conf) {
        if (this.indexWriters == null) {
            try {
                ExtensionPoint point = PluginRepository.get(conf).getExtensionPoint(IndexWriter.X_POINT_ID);
                if (point == null) {
                    throw new RuntimeException(IndexWriter.X_POINT_ID + " not found.");
                }
                Extension[] extensions = point.getExtensions();
                HashMap<String, Extension> extensionMap = new HashMap<String, Extension>();
                for (Extension extension : extensions) {
                    LOG.info("Index writer {} identified.", (Object)extension.getClazz());
                    extensionMap.putIfAbsent(extension.getClazz(), extension);
                }
                IndexWriterConfig[] indexWriterConfigs = this.loadWritersConfiguration(conf);
                this.indexWriters = new HashMap();
                for (IndexWriterConfig indexWriterConfig : indexWriterConfigs) {
                    String clazz = indexWriterConfig.getClazz();
                    if (!extensionMap.containsKey(clazz)) continue;
                    IndexWriterWrapper writerWrapper = new IndexWriterWrapper();
                    writerWrapper.setIndexWriterConfig(indexWriterConfig);
                    writerWrapper.setIndexWriter((IndexWriter)((Extension)extensionMap.get(clazz)).getExtensionInstance());
                    this.indexWriters.put(indexWriterConfig.getId(), writerWrapper);
                }
                this.exchanges = new Exchanges(conf);
                this.exchanges.open();
            }
            catch (PluginRuntimeException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private IndexWriterConfig[] loadWritersConfiguration(Configuration conf) {
        String filename = conf.get("indexer.indexwriters.file", "index-writers.xml");
        InputStream ssInputStream = conf.getConfResourceAsInputStream(filename);
        InputSource inputSource = new InputSource(ssInputStream);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputSource);
            Element rootElement = document.getDocumentElement();
            NodeList writerList = rootElement.getElementsByTagName("writer");
            IndexWriterConfig[] indexWriterConfigs = new IndexWriterConfig[writerList.getLength()];
            for (int i = 0; i < writerList.getLength(); ++i) {
                indexWriterConfigs[i] = IndexWriterConfig.getInstanceFromElement((Element)writerList.item(i));
            }
            return indexWriterConfigs;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("Failed to read index writers configuration: {}", (Object)e.getMessage());
            return new IndexWriterConfig[0];
        }
    }

    private NutchDocument mapDocument(NutchDocument document, Map<MappingReader.Actions, Map<String, List<String>>> mapping) {
        try {
            NutchDocument mappedDocument = document.clone();
            mapping.get((Object)MappingReader.Actions.COPY).forEach((key, value) -> {
                if (mappedDocument.getField((String)key) != null) {
                    for (String field : value) {
                        if (key.equals(field)) continue;
                        for (Object val : mappedDocument.getField((String)key).getValues()) {
                            mappedDocument.add(field, val);
                        }
                    }
                }
            });
            mapping.get((Object)MappingReader.Actions.RENAME).forEach((key, value) -> {
                if (mappedDocument.getField((String)key) != null) {
                    NutchField field = mappedDocument.removeField((String)key);
                    mappedDocument.add((String)value.get(0), field.getValues());
                    mappedDocument.getField((String)value.get(0)).setWeight(field.getWeight());
                }
            });
            mapping.get((Object)MappingReader.Actions.REMOVE).forEach((key, value) -> mappedDocument.removeField((String)key));
            return mappedDocument;
        }
        catch (CloneNotSupportedException e) {
            LOG.warn("An instance of class {} can't be cloned.", (Object)document.getClass().getName());
            return document;
        }
    }

    private Collection<String> getIndexWriters(NutchDocument doc) {
        if (this.exchanges.areAvailableExchanges()) {
            return Arrays.asList(this.exchanges.indexWriters(doc));
        }
        return this.indexWriters.keySet();
    }

    public void open(Configuration conf, String name) throws IOException {
        for (Map.Entry<String, IndexWriterWrapper> entry : this.indexWriters.entrySet()) {
            entry.getValue().getIndexWriter().open(conf, name);
            entry.getValue().getIndexWriter().open(entry.getValue().getIndexWriterConfig().getParams());
        }
    }

    public void write(NutchDocument doc) throws IOException {
        for (String indexWriterId : this.getIndexWriters(doc)) {
            if (!this.indexWriters.containsKey(indexWriterId)) {
                LOG.warn("Index writer {} is not present. Maybe the plugin is not in plugin.includes or there is a misspelling.", (Object)indexWriterId);
                continue;
            }
            NutchDocument mappedDocument = this.mapDocument(doc, this.indexWriters.get(indexWriterId).getIndexWriterConfig().getMapping());
            this.indexWriters.get(indexWriterId).getIndexWriter().write(mappedDocument);
        }
    }

    public void update(NutchDocument doc) throws IOException {
        for (String indexWriterId : this.getIndexWriters(doc)) {
            if (!this.indexWriters.containsKey(indexWriterId)) {
                LOG.warn("Index writer {} is not present. Maybe the plugin is not in plugin.includes or there is a misspelling.", (Object)indexWriterId);
                continue;
            }
            NutchDocument mappedDocument = this.mapDocument(doc, this.indexWriters.get(indexWriterId).getIndexWriterConfig().getMapping());
            this.indexWriters.get(indexWriterId).getIndexWriter().update(mappedDocument);
        }
    }

    public void delete(String key) throws IOException {
        for (IndexWriterWrapper iww : this.indexWriters.values()) {
            iww.getIndexWriter().delete(key);
        }
    }

    public void close() throws IOException {
        for (Map.Entry<String, IndexWriterWrapper> entry : this.indexWriters.entrySet()) {
            entry.getValue().getIndexWriter().close();
        }
    }

    public void commit() throws IOException {
        for (Map.Entry<String, IndexWriterWrapper> entry : this.indexWriters.entrySet()) {
            entry.getValue().getIndexWriter().commit();
        }
    }

    public String describe() {
        StringBuilder builder = new StringBuilder();
        if (this.indexWriters.size() == 0) {
            builder.append("No IndexWriters activated - check your configuration\n");
        } else {
            builder.append("Active IndexWriters :\n");
        }
        for (IndexWriterWrapper indexWriterWrapper : this.indexWriters.values()) {
            builder.append(indexWriterWrapper.getIndexWriter().getClass().getSimpleName()).append(":\n");
            AsciiTable at = new AsciiTable();
            at.getRenderer().setCWC((rows, colNumbers, tableWidth) -> {
                int maxLengthFirstColumn = 0;
                int maxLengthThirdColumn = 0;
                for (AT_Row row : rows) {
                    if (row.getType() != TableRowType.CONTENT) continue;
                    maxLengthFirstColumn = Math.max(((AT_Cell)row.getCells().get(0)).toString().length(), maxLengthFirstColumn);
                    maxLengthThirdColumn = Math.max(((AT_Cell)row.getCells().get(2)).toString().length(), maxLengthThirdColumn);
                }
                maxLengthFirstColumn = Math.min(tableWidth / 3, maxLengthFirstColumn);
                maxLengthThirdColumn = Math.min((tableWidth - maxLengthFirstColumn) / 2, maxLengthThirdColumn);
                int widthSecondColumn = tableWidth - maxLengthFirstColumn - maxLengthThirdColumn;
                return new int[]{maxLengthFirstColumn, widthSecondColumn, maxLengthThirdColumn};
            });
            Map<String, Map.Entry<String, Object>> properties = indexWriterWrapper.getIndexWriter().describe();
            properties.forEach((key, value) -> {
                at.addRule();
                at.addRow(new Object[]{key, value.getKey(), value.getValue() != null ? value.getValue() : ""});
            });
            at.addRule();
            builder.append(at.render(120)).append("\n\n");
        }
        return builder.toString();
    }

    public class IndexWriterWrapper {
        private IndexWriterConfig indexWriterConfig;
        private IndexWriter indexWriter;

        IndexWriterConfig getIndexWriterConfig() {
            return this.indexWriterConfig;
        }

        void setIndexWriterConfig(IndexWriterConfig indexWriterConfig) {
            this.indexWriterConfig = indexWriterConfig;
        }

        IndexWriter getIndexWriter() {
            return this.indexWriter;
        }

        void setIndexWriter(IndexWriter indexWriter) {
            this.indexWriter = indexWriter;
        }
    }
}

