/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.locks.ReadWriteLock;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0002\u0004\u0001\u0017!A!\u0003\u0001B\u0001B\u0003%1\u0003\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u0015a\u0003\u0001\"\u0001.\u0011\u0015\u0011\u0004\u0001\"\u00014\u00051\u0019VM\\:pe\u0006\u001b7-Z:t\u0015\t9\u0001\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0013\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\u0006!An\\2l!\t!R$D\u0001\u0016\u0015\t1r#A\u0003m_\u000e\\7O\u0003\u0002\u00193\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005iY\u0012\u0001B;uS2T\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f+\ti!+Z1e/JLG/\u001a'pG.\fq!\\3ue&\u001c7\u000f\u0005\u0002\"U5\t!E\u0003\u0002 G)\u0011A%J\u0001\u0007G>lWn\u001c8\u000b\u0005%1#BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001eL!a\u000b\u0012\u0003\u000f5+GO]5dg\u00061A(\u001b8jiz\"2A\f\u00192!\ty\u0003!D\u0001\u0007\u0011\u0015\u00112\u00011\u0001\u0014\u0011\u0015y2\u00011\u0001!\u0003-9W\r^(s\u0007J,\u0017\r^3\u0015\tQ:D)\u0013\t\u0003CUJ!A\u000e\u0012\u0003\rM+gn]8s\u0011\u0015AD\u00011\u0001:\u0003)\u0019XM\\:pe:\u000bW.\u001a\t\u0003u\u0005s!aO \u0011\u0005qrQ\"A\u001f\u000b\u0005yR\u0011A\u0002\u001fs_>$h(\u0003\u0002A\u001d\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001e\u0002C\u0003F\t\u0001\u0007a)\u0001\bfqBL'/\u0019;j_:$\u0016.\\3\u0011\u000559\u0015B\u0001%\u000f\u0005\u0011auN\\4\t\u000b)#\u0001\u0019A&\u0002\u001fI,w-[:uKJlU\r\u001e:jGN\u0004B!\u0004'5\u001d&\u0011QJ\u0004\u0002\n\rVt7\r^5p]F\u0002\"!D(\n\u0005As!\u0001B+oSR\u0004")
public class SensorAccess {
    private final ReadWriteLock lock;
    private final Metrics metrics;

    public Sensor getOrCreate(String sensorName, long expirationTime, Function1<Sensor, BoxedUnit> registerMetrics) {
        Sensor sensor;
        this.lock.readLock().lock();
        try {
            sensor = this.metrics.getSensor(sensorName);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (sensor == null) {
            this.lock.writeLock().lock();
            try {
                sensor = this.metrics.getSensor(sensorName);
                if (sensor == null) {
                    sensor = this.metrics.sensor(sensorName, null, expirationTime, new Sensor[0]);
                    registerMetrics.apply((Object)sensor);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return sensor;
    }

    public SensorAccess(ReadWriteLock lock, Metrics metrics) {
        this.lock = lock;
        this.metrics = metrics;
    }
}

