/****************************************************************************
 * arch/x86_64/src/intel64/intel64_lowsetup.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_X86_64_SRC_INTEL64_INTEL64_LOWSETUP_H
#define __ARCH_X86_64_SRC_INTEL64_INTEL64_LOWSETUP_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#ifndef __ASSEMBLY__

#undef EXTERN
#if defined(__cplusplus)
#define EXTERN extern "C"
extern "C"
{
#else
#define EXTERN extern
#endif

/****************************************************************************
 * Public Function Prototypes
 ****************************************************************************/

/****************************************************************************
 * Name: intel64_lowsetup
 *
 * Description:
 *   Called at the very beginning of _nxstart or up_ap_boot.
 *   Performs low level initializationincluding setup of the console UART.
 *   This UART done early so that the serial console is available for
 *   debugging very early in the boot sequence.
 *
 ****************************************************************************/

void intel64_lowsetup(void);

/****************************************************************************
 * Name: intel64_timer_secondary_init
 *
 * Description:
 *   Called for the secondary CPUs to initialize the timer subsystem.
 *
 ****************************************************************************/

void intel64_timer_secondary_init(void);

#undef EXTERN
#if defined(__cplusplus)
}
#endif

#endif /* __ASSEMBLY__ */
#endif /* __ARCH_X86_64_SRC_INTEL64_INTEL64_LOWSETUP_H */
