/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.jpql;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLSelectContextView;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;

public class JPQLSelectContext
extends JPQLContext
implements JPQLSelectContextView {
    protected String selectExpression;
    protected String orderByCollection;
    protected String whereCondition;
    protected Map<String, Map<Integer, Object>> parameterizedQueryMap;
    protected String jpqlStatement;
    protected boolean isCountOnly = false;

    public JPQLSelectContext(boolean isCountOnly) {
        this.isCountOnly = isCountOnly;
    }

    protected final void setOrderByCollection(String orderByCollection) {
        this.orderByCollection = orderByCollection;
    }

    protected final void setWhereExpression(String filterExpression) {
        this.whereCondition = filterExpression;
    }

    protected final void setParameterizedQueryMap(Map<String, Map<Integer, Object>> parameterizedQueryMap) {
        if (null == this.parameterizedQueryMap || this.parameterizedQueryMap.isEmpty()) {
            this.parameterizedQueryMap = parameterizedQueryMap;
        } else {
            this.parameterizedQueryMap.putAll(parameterizedQueryMap);
        }
    }

    protected final void setSelectExpression(String selectExpression) {
        this.selectExpression = selectExpression;
    }

    public String getSelectExpression() {
        return this.selectExpression;
    }

    public String getOrderByCollection() {
        return this.orderByCollection;
    }

    public String getWhereExpression() {
        return this.whereCondition;
    }

    private int getIndexValue(Map<Integer, Object> map) {
        int index = 1;
        if (map != null) {
            for (Map.Entry<Integer, Object> entry : map.entrySet()) {
                index = entry.getKey();
            }
            return index + 1;
        }
        return index;
    }

    public Map<String, Map<Integer, Object>> getParameterizedQueryMap() {
        return this.parameterizedQueryMap;
    }

    public void setJPQLStatement(String jpqlStatement) {
        this.jpqlStatement = jpqlStatement;
    }

    public String getJPQLStatement() {
        return this.jpqlStatement;
    }

    public class JPQLSelectContextBuilder
    extends JPQLContext.JPQLContextBuilder {
        protected GetEntitySetUriInfo entitySetView;

        public JPQLContext build() throws ODataJPAModelException, ODataJPARuntimeException {
            if (this.entitySetView != null) {
                try {
                    EdmEntityType entityType;
                    EdmMapping mapping;
                    if (JPQLSelectContext.this.isCountOnly) {
                        JPQLSelectContext.this.setType(JPQLContextType.SELECT_COUNT);
                    } else {
                        JPQLSelectContext.this.setType(JPQLContextType.SELECT);
                    }
                    if (this.withPaging) {
                        JPQLSelectContext.this.isPagingRequested(this.withPaging);
                    }
                    if ((mapping = (entityType = this.entitySetView.getTargetEntitySet().getEntityType()).getMapping()) != null) {
                        JPQLSelectContext.this.setJPAEntityName(mapping.getInternalName());
                    } else {
                        JPQLSelectContext.this.setJPAEntityName(entityType.getName());
                    }
                    JPQLSelectContext.this.setJPAEntityAlias(this.generateJPAEntityAlias());
                    JPQLSelectContext.this.setOrderByCollection(this.generateOrderByFileds());
                    JPQLSelectContext.this.setSelectExpression(this.generateSelectExpression());
                    JPQLSelectContext.this.setWhereExpression(this.generateWhereExpression());
                    JPQLSelectContext.setJPQLContext((JPQLContext)JPQLSelectContext.this);
                }
                catch (ODataException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
                }
            }
            return JPQLSelectContext.this;
        }

        protected void setResultsView(Object resultsView) {
            if (resultsView instanceof GetEntitySetUriInfo) {
                this.entitySetView = (GetEntitySetUriInfo)resultsView;
            }
        }

        protected String generateSelectExpression() throws EdmException {
            return JPQLSelectContext.this.getJPAEntityAlias();
        }

        protected String generateOrderByFileds() throws ODataJPARuntimeException, EdmException {
            if (this.entitySetView.getOrderBy() != null && !JPQLSelectContext.this.isCountOnly) {
                return ODataExpressionParser.parseToJPAOrderByExpression(this.entitySetView.getOrderBy(), JPQLSelectContext.this.getJPAEntityAlias());
            }
            if ((this.entitySetView.getTop() != null || this.entitySetView.getSkip() != null || JPQLSelectContext.this.pagingRequested) && !JPQLSelectContext.this.isCountOnly) {
                return ODataExpressionParser.parseKeyPropertiesToJPAOrderByExpression(this.entitySetView.getTargetEntitySet().getEntityType().getKeyProperties(), JPQLSelectContext.this.getJPAEntityAlias());
            }
            return null;
        }

        protected String generateWhereExpression() throws ODataException {
            if (this.entitySetView.getFilter() != null) {
                String whereExpression = null;
                if (null != JPQLSelectContext.this.parameterizedQueryMap && !JPQLSelectContext.this.parameterizedQueryMap.isEmpty()) {
                    int index = 1;
                    int previousIndex = 1;
                    for (Map.Entry<String, Map<Integer, Object>> parameter : JPQLSelectContext.this.parameterizedQueryMap.entrySet()) {
                        index = JPQLSelectContext.this.getIndexValue(parameter.getValue());
                        if (index <= previousIndex) continue;
                        previousIndex = index;
                    }
                    whereExpression = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)this.entitySetView.getFilter(), JPQLSelectContext.this.getJPAEntityAlias(), previousIndex, new ConcurrentHashMap<Integer, Object>(), null);
                } else {
                    whereExpression = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)this.entitySetView.getFilter(), JPQLSelectContext.this.getJPAEntityAlias());
                }
                HashMap<String, Map<Integer, Object>> parameterizedExpressionMap = new HashMap<String, Map<Integer, Object>>();
                parameterizedExpressionMap.put(whereExpression, ODataExpressionParser.getPositionalParametersThreadLocal());
                JPQLSelectContext.this.setParameterizedQueryMap(parameterizedExpressionMap);
                return whereExpression;
            }
            return null;
        }
    }
}

