/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.tenant;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.TenantArgs;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.tenant.TenantHandler;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create a tenant. This can create a new Ozone volume for the tenant."})
public class TenantCreateHandler
extends TenantHandler {
    @CommandLine.Parameters(description={"Tenant name"}, arity="1..1")
    private String tenantId;
    @CommandLine.Option(names={"-f", "--force"}, description={"(Optional) Force tenant creation even when volume exists. This does NOT override other errors like Ranger failure."}, hidden=true)
    private boolean forceCreationWhenVolumeExists;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        TenantArgs tenantArgs = TenantArgs.newBuilder().setVolumeName(this.tenantId).setForceCreationWhenVolumeExists(this.forceCreationWhenVolumeExists).build();
        client.getObjectStore().createTenant(this.tenantId, tenantArgs);
        if (this.isVerbose()) {
            ObjectNode obj = JsonUtils.createObjectNode(null);
            obj.put("tenantId", this.tenantId);
            String jsonString = JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)obj);
            this.out().println(jsonString);
        }
    }
}

