/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jooq.tools.reflect.Reflect;
import org.jooq.tools.reflect.ReflectException;

class Compile {
    Compile() {
    }

    static Class<?> compile(String className, String content) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ClassLoader cl = lookup.lookupClass().getClassLoader();
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException ignore) {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            try {
                ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
                ArrayList<CharSequenceJavaFileObject> files = new ArrayList<CharSequenceJavaFileObject>();
                files.add(new CharSequenceJavaFileObject(className, content));
                StringWriter out = new StringWriter();
                ArrayList<String> options = new ArrayList<String>();
                StringBuilder classpath = new StringBuilder();
                String separator = System.getProperty("path.separator");
                String prop = System.getProperty("java.class.path");
                if (prop != null && !"".equals(prop)) {
                    classpath.append(prop);
                }
                if (cl instanceof URLClassLoader) {
                    for (URL url : ((URLClassLoader)cl).getURLs()) {
                        if (classpath.length() > 0) {
                            classpath.append(separator);
                        }
                        if (!"file".equals(url.getProtocol())) continue;
                        classpath.append(new File(url.getFile()));
                    }
                }
                options.addAll(Arrays.asList("-classpath", classpath.toString()));
                compiler.getTask(out, fileManager, null, options, null, files).call();
                if (fileManager.o == null) {
                    throw new ReflectException("Compilation error: " + out);
                }
                Class result = null;
                byte[] b = fileManager.o.getBytes();
                result = (Class)Reflect.on(cl).call("defineClass", className, b, 0, b.length).get();
                return result;
            }
            catch (ReflectException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ReflectException("Error while compiling " + className, e);
            }
        }
    }

    static final class CharSequenceJavaFileObject
    extends SimpleJavaFileObject {
        final CharSequence content;

        public CharSequenceJavaFileObject(String className, CharSequence content) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }
    }

    static final class ClassFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        JavaFileObject o;

        ClassFileManager(StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
            this.o = new JavaFileObject(className, kind);
            return this.o;
        }
    }

    static final class JavaFileObject
    extends SimpleJavaFileObject {
        final ByteArrayOutputStream os = new ByteArrayOutputStream();

        JavaFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/') + kind.extension), kind);
        }

        byte[] getBytes() {
            return this.os.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() {
            return this.os;
        }
    }
}

