/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import picocli.CommandLine;

public abstract class HadoopBaseFreonGenerator
extends BaseFreonGenerator {
    @CommandLine.Option(names={"-r", "--rpath", "--path"}, description={"Hadoop FS file system path. Use full path."}, defaultValue="o3fs://bucket1.vol1")
    private String rootPath;
    private final ThreadLocal<FileSystem> threadLocalFileSystem = ThreadLocal.withInitial(this::createFS);
    private OzoneConfiguration configuration;
    private URI uri;

    @Override
    public void init() {
        super.init();
        this.configuration = this.createOzoneConfiguration();
        this.uri = URI.create(this.rootPath);
        String scheme = Optional.ofNullable(this.uri.getScheme()).orElseGet(() -> FileSystem.getDefaultUri((Configuration)this.configuration).getScheme());
        String disableCacheName = String.format("fs.%s.impl.disable.cache", scheme);
        this.print("Disabling FS cache: " + disableCacheName);
        this.configuration.setBoolean(disableCacheName, true);
    }

    @Override
    protected void taskLoopCompleted() {
        FileSystem fileSystem = this.threadLocalFileSystem.get();
        try {
            fileSystem.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String getRootPath() {
        return this.rootPath;
    }

    protected FileSystem getFileSystem() {
        return this.threadLocalFileSystem.get();
    }

    private FileSystem createFS() {
        try {
            return FileSystem.get((URI)this.uri, (Configuration)this.configuration);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

