/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.protobuf.ProtocolMessageEnum;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeProtocolServer;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.ozone.protocol.ReconDatanodeProtocol;
import org.apache.hadoop.ozone.protocolPB.ReconDatanodeProtocolPB;
import org.apache.hadoop.ozone.recon.scm.ReconPolicyProvider;
import org.apache.hadoop.security.authorize.PolicyProvider;

public class ReconDatanodeProtocolServer
extends SCMDatanodeProtocolServer
implements ReconDatanodeProtocol {
    public ReconDatanodeProtocolServer(OzoneConfiguration conf, OzoneStorageContainerManager scm, EventPublisher eventPublisher) throws IOException {
        super(conf, scm, eventPublisher, null);
    }

    public ProtocolMessageMetrics<ProtocolMessageEnum> getProtocolMessageMetrics() {
        return ProtocolMessageMetrics.create((String)"ReconDatanodeProtocol", (String)"Recon Datanode protocol", (Object[])StorageContainerDatanodeProtocolProtos.Type.values());
    }

    protected String getDatanodeAddressKey() {
        return "ozone.recon.datanode.address";
    }

    public InetSocketAddress getDataNodeBindAddress(OzoneConfiguration conf, SCMNodeDetails scmNodeDetails) {
        return HddsServerUtil.getReconDataNodeBindAddress((ConfigurationSource)conf);
    }

    protected PolicyProvider getPolicyProvider() {
        return ReconPolicyProvider.getInstance();
    }

    protected Class<ReconDatanodeProtocolPB> getProtocolClass() {
        return ReconDatanodeProtocolPB.class;
    }
}

