/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.node.DeadNodeHandler;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.recon.fsck.ContainerHealthTask;
import org.apache.hadoop.ozone.recon.scm.PipelineSyncTask;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconDeadNodeHandler
extends DeadNodeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReconDeadNodeHandler.class);
    private StorageContainerServiceProvider scmClient;
    private ContainerHealthTask containerHealthTask;
    private PipelineSyncTask pipelineSyncTask;

    public ReconDeadNodeHandler(NodeManager nodeManager, PipelineManager pipelineManager, ContainerManager containerManager, StorageContainerServiceProvider scmClient, ContainerHealthTask containerHealthTask, PipelineSyncTask pipelineSyncTask) {
        super(nodeManager, pipelineManager, containerManager);
        this.scmClient = scmClient;
        this.containerHealthTask = containerHealthTask;
        this.pipelineSyncTask = pipelineSyncTask;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher publisher) {
        super.onMessage(datanodeDetails, publisher);
        ReconNodeManager nodeManager = (ReconNodeManager)this.getNodeManager();
        try {
            List<HddsProtos.Node> nodes = this.scmClient.getNodes();
            Optional<HddsProtos.Node> matchedDn = nodes.stream().filter(n -> n.getNodeID().getUuid().equals(datanodeDetails.getUuidString())).findAny();
            if (matchedDn.isPresent()) {
                nodeManager.updateNodeOperationalStateFromScm(matchedDn.get(), datanodeDetails);
            } else {
                LOG.warn("Node {} has reached DEAD state, but SCM does not have information about it.", (Object)datanodeDetails);
            }
            this.containerHealthTask.initializeAndRunTask();
            this.pipelineSyncTask.initializeAndRunTask();
        }
        catch (Exception ioEx) {
            LOG.error("Error trying to verify Node operational state from SCM.", (Throwable)ioEx);
        }
    }
}

