/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.types.ContainerKeyPrefix;
import org.apache.hadoop.ozone.recon.api.types.ContainerMetadata;
import org.apache.hadoop.ozone.recon.api.types.KeyPrefixContainer;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistory;
import org.apache.hadoop.ozone.recon.scm.ContainerReplicaHistoryList;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBProvider;
import org.apache.ozone.recon.schema.generated.tables.daos.GlobalStatsDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.GlobalStats;
import org.jooq.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconContainerMetadataManagerImpl
implements ReconContainerMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconContainerMetadataManagerImpl.class);
    private Table<ContainerKeyPrefix, Integer> containerKeyTable;
    private Table<KeyPrefixContainer, Integer> keyContainerTable;
    private Table<Long, Long> containerKeyCountTable;
    private Table<Long, ContainerReplicaHistoryList> containerReplicaHistoryTable;
    private GlobalStatsDao globalStatsDao;
    private DBStore containerDbStore;
    @Inject
    private Configuration sqlConfiguration;
    @Inject
    private ReconOMMetadataManager omMetadataManager;

    @Inject
    public ReconContainerMetadataManagerImpl(ReconDBProvider reconDBProvider, Configuration sqlConfiguration) {
        this.containerDbStore = reconDBProvider.getDbStore();
        this.globalStatsDao = new GlobalStatsDao(sqlConfiguration);
        this.initializeTables();
    }

    @Override
    public void reinitWithNewContainerDataFromOm(Map<ContainerKeyPrefix, Integer> containerKeyPrefixCounts) throws IOException {
        ReconDBProvider.truncateTable(this.containerKeyTable);
        ReconDBProvider.truncateTable(this.keyContainerTable);
        ReconDBProvider.truncateTable(this.containerKeyCountTable);
        this.initializeTables();
        if (containerKeyPrefixCounts != null) {
            for (Map.Entry<ContainerKeyPrefix, Integer> entry : containerKeyPrefixCounts.entrySet()) {
                this.containerKeyTable.put((Object)entry.getKey(), (Object)entry.getValue());
                KeyPrefixContainer tmpKeyPrefixContainer = entry.getKey().toKeyPrefixContainer();
                if (tmpKeyPrefixContainer == null) continue;
                this.keyContainerTable.put((Object)tmpKeyPrefixContainer, (Object)entry.getValue());
            }
        }
        this.storeContainerCount(0L);
    }

    private void initializeTables() {
        try {
            this.containerKeyTable = ReconDBDefinition.CONTAINER_KEY.getTable(this.containerDbStore);
            this.keyContainerTable = ReconDBDefinition.KEY_CONTAINER.getTable(this.containerDbStore);
            if (this.keyContainerTable.isEmpty()) {
                LOG.info("KEY_CONTAINER Table is empty, initializing from CONTAINER_KEY Table ...");
                this.initializeKeyContainerTable();
            }
            this.containerKeyCountTable = ReconDBDefinition.CONTAINER_KEY_COUNT.getTable(this.containerDbStore);
            this.containerReplicaHistoryTable = ReconDBDefinition.REPLICA_HISTORY_V2.getTable(this.containerDbStore);
        }
        catch (IOException e) {
            LOG.error("Unable to create Container Key tables.", (Throwable)e);
        }
    }

    @Override
    public void storeContainerKeyMapping(ContainerKeyPrefix containerKeyPrefix, Integer count) throws IOException {
        this.containerKeyTable.put((Object)containerKeyPrefix, (Object)count);
        if (containerKeyPrefix.toKeyPrefixContainer() != null) {
            this.keyContainerTable.put((Object)containerKeyPrefix.toKeyPrefixContainer(), (Object)count);
        }
    }

    @Override
    public void batchStoreContainerKeyMapping(BatchOperation batch, ContainerKeyPrefix containerKeyPrefix, Integer count) throws IOException {
        this.containerKeyTable.putWithBatch(batch, (Object)containerKeyPrefix, (Object)count);
        if (containerKeyPrefix.toKeyPrefixContainer() != null) {
            this.keyContainerTable.putWithBatch(batch, (Object)containerKeyPrefix.toKeyPrefixContainer(), (Object)count);
        }
    }

    @Override
    public void storeContainerKeyCount(Long containerID, Long count) throws IOException {
        this.containerKeyCountTable.put((Object)containerID, (Object)count);
    }

    @Override
    public void batchStoreContainerKeyCounts(BatchOperation batch, Long containerID, Long count) throws IOException {
        this.containerKeyCountTable.putWithBatch(batch, (Object)containerID, (Object)count);
    }

    @Override
    public void storeContainerReplicaHistory(Long containerID, Map<UUID, ContainerReplicaHistory> tsMap) throws IOException {
        ArrayList<ContainerReplicaHistory> tsList = new ArrayList<ContainerReplicaHistory>();
        for (Map.Entry<UUID, ContainerReplicaHistory> e : tsMap.entrySet()) {
            tsList.add(e.getValue());
        }
        this.containerReplicaHistoryTable.put((Object)containerID, (Object)new ContainerReplicaHistoryList(tsList));
    }

    @Override
    public void batchStoreContainerReplicaHistory(Map<Long, Map<UUID, ContainerReplicaHistory>> replicaHistoryMap) throws IOException {
        try (BatchOperation batchOperation = this.containerDbStore.initBatchOperation();){
            for (Map.Entry<Long, Map<UUID, ContainerReplicaHistory>> entry : replicaHistoryMap.entrySet()) {
                long containerId = entry.getKey();
                Map<UUID, ContainerReplicaHistory> tsMap = entry.getValue();
                ArrayList<ContainerReplicaHistory> tsList = new ArrayList<ContainerReplicaHistory>();
                for (Map.Entry<UUID, ContainerReplicaHistory> e : tsMap.entrySet()) {
                    tsList.add(e.getValue());
                }
                this.containerReplicaHistoryTable.putWithBatch(batchOperation, (Object)containerId, (Object)new ContainerReplicaHistoryList(tsList));
            }
            this.containerDbStore.commitBatchOperation(batchOperation);
        }
    }

    @Override
    public long getKeyCountForContainer(Long containerID) throws IOException {
        Long keyCount = (Long)this.containerKeyCountTable.get((Object)containerID);
        return keyCount == null ? 0L : keyCount;
    }

    @Override
    public Map<UUID, ContainerReplicaHistory> getContainerReplicaHistory(Long containerID) throws IOException {
        ContainerReplicaHistoryList tsList = (ContainerReplicaHistoryList)this.containerReplicaHistoryTable.get((Object)containerID);
        if (tsList == null) {
            return new HashMap<UUID, ContainerReplicaHistory>();
        }
        HashMap<UUID, ContainerReplicaHistory> res = new HashMap<UUID, ContainerReplicaHistory>();
        for (ContainerReplicaHistory ts : tsList.getList()) {
            UUID uuid = ts.getUuid();
            res.put(uuid, ts);
        }
        return res;
    }

    @Override
    public boolean doesContainerExists(Long containerID) throws IOException {
        return this.containerKeyCountTable.isExist((Object)containerID);
    }

    @Override
    public Integer getCountForContainerKeyPrefix(ContainerKeyPrefix containerKeyPrefix) throws IOException {
        Integer count = (Integer)this.containerKeyTable.get((Object)containerKeyPrefix);
        return count == null ? Integer.valueOf(0) : count;
    }

    @Override
    public Map<ContainerKeyPrefix, Integer> getKeyPrefixesForContainer(long containerId) throws IOException {
        return this.getKeyPrefixesForContainer(containerId, "");
    }

    @Override
    public Map<ContainerKeyPrefix, Integer> getKeyPrefixesForContainer(long containerId, String prevKeyPrefix) throws IOException {
        LinkedHashMap<ContainerKeyPrefix, Integer> prefixes = new LinkedHashMap<ContainerKeyPrefix, Integer>();
        try (TableIterator containerIterator = this.containerKeyTable.iterator();){
            ContainerKeyPrefix seekKey;
            boolean skipPrevKey = false;
            if (StringUtils.isNotBlank((CharSequence)prevKeyPrefix)) {
                skipPrevKey = true;
                seekKey = ContainerKeyPrefix.get(containerId, prevKeyPrefix);
            } else {
                seekKey = ContainerKeyPrefix.get(containerId);
            }
            Table.KeyValue seekKeyValue = (Table.KeyValue)containerIterator.seek((Object)seekKey);
            if (seekKeyValue == null || StringUtils.isNotBlank((CharSequence)prevKeyPrefix) && !((ContainerKeyPrefix)seekKeyValue.getKey()).getKeyPrefix().equals(prevKeyPrefix)) {
                LinkedHashMap<ContainerKeyPrefix, Integer> linkedHashMap = prefixes;
                return linkedHashMap;
            }
            while (containerIterator.hasNext()) {
                Table.KeyValue keyValue = (Table.KeyValue)containerIterator.next();
                ContainerKeyPrefix containerKeyPrefix = (ContainerKeyPrefix)keyValue.getKey();
                if (skipPrevKey && containerKeyPrefix.getKeyPrefix().equals(prevKeyPrefix)) continue;
                if (containerKeyPrefix.getContainerId() == containerId) {
                    if (StringUtils.isNotEmpty((CharSequence)containerKeyPrefix.getKeyPrefix())) {
                        prefixes.put(containerKeyPrefix, (Integer)keyValue.getValue());
                        continue;
                    }
                    LOG.warn("Null key prefix returned for containerId = {} ", (Object)containerId);
                    continue;
                }
                break;
            }
        }
        return prefixes;
    }

    @Override
    public Map<Long, ContainerMetadata> getContainers(int limit, long prevContainer) throws IOException {
        LinkedHashMap<Long, ContainerMetadata> containers = new LinkedHashMap<Long, ContainerMetadata>();
        try (TableIterator containerIterator = this.containerKeyTable.iterator();){
            if (prevContainer > 0L) {
                ContainerKeyPrefix seekKey = ContainerKeyPrefix.get(prevContainer);
                Table.KeyValue seekKeyValue = (Table.KeyValue)containerIterator.seek((Object)seekKey);
                if (seekKeyValue != null && ((ContainerKeyPrefix)seekKeyValue.getKey()).getContainerId() != prevContainer) {
                    LinkedHashMap<Long, ContainerMetadata> linkedHashMap = containers;
                    return linkedHashMap;
                }
                seekKey = ContainerKeyPrefix.get(prevContainer + 1L);
                containerIterator.seek((Object)seekKey);
            }
            while (containerIterator.hasNext()) {
                Table.KeyValue keyValue = (Table.KeyValue)containerIterator.next();
                ContainerKeyPrefix containerKeyPrefix = (ContainerKeyPrefix)keyValue.getKey();
                Long containerID = containerKeyPrefix.getContainerId();
                Integer numberOfKeys = (Integer)keyValue.getValue();
                List<Pipeline> pipelines = this.getPipelines(containerKeyPrefix);
                if (containers.size() == limit && !containers.containsKey(containerID)) {
                    break;
                }
                containers.computeIfAbsent(containerID, ContainerMetadata::new);
                ContainerMetadata containerMetadata = (ContainerMetadata)containers.get(containerID);
                containerMetadata.setNumberOfKeys(containerMetadata.getNumberOfKeys() + (long)numberOfKeys.intValue());
                containerMetadata.setPipelines(pipelines);
                containers.put(containerID, containerMetadata);
            }
        }
        return containers;
    }

    @Nonnull
    private List<Pipeline> getPipelines(ContainerKeyPrefix containerKeyPrefix) throws IOException {
        OmKeyInfo omKeyInfo = (OmKeyInfo)this.omMetadataManager.getKeyTable(BucketLayout.LEGACY).getSkipCache((Object)containerKeyPrefix.getKeyPrefix());
        if (null == omKeyInfo) {
            omKeyInfo = (OmKeyInfo)this.omMetadataManager.getKeyTable(BucketLayout.FILE_SYSTEM_OPTIMIZED).getSkipCache((Object)containerKeyPrefix.getKeyPrefix());
        }
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
        if (null != omKeyInfo) {
            omKeyInfo.getKeyLocationVersions().stream().map(omKeyLocationInfoGroup -> omKeyLocationInfoGroup.getLocationList().stream().map(omKeyLocationInfo -> pipelines.add(omKeyLocationInfo.getPipeline())));
        }
        return pipelines;
    }

    @Override
    public void deleteContainerMapping(ContainerKeyPrefix containerKeyPrefix) throws IOException {
        this.containerKeyTable.delete((Object)containerKeyPrefix);
        if (!StringUtils.isEmpty((CharSequence)containerKeyPrefix.getKeyPrefix())) {
            this.keyContainerTable.delete((Object)containerKeyPrefix.toKeyPrefixContainer());
        }
    }

    @Override
    public void batchDeleteContainerMapping(BatchOperation batch, ContainerKeyPrefix containerKeyPrefix) throws IOException {
        this.containerKeyTable.deleteWithBatch(batch, (Object)containerKeyPrefix);
        if (!StringUtils.isEmpty((CharSequence)containerKeyPrefix.getKeyPrefix())) {
            this.keyContainerTable.deleteWithBatch(batch, (Object)containerKeyPrefix.toKeyPrefixContainer());
        }
    }

    @Override
    public long getCountForContainers() {
        GlobalStats containerCountRecord = this.globalStatsDao.fetchOneByKey("containerCount");
        return containerCountRecord == null ? 0L : containerCountRecord.getValue();
    }

    @Override
    public TableIterator getContainerTableIterator() throws IOException {
        return this.containerKeyTable.iterator();
    }

    @Override
    public TableIterator getKeyContainerTableIterator() throws IOException {
        return this.keyContainerTable.iterator();
    }

    @Override
    public Table<KeyPrefixContainer, Integer> getKeyContainerTable() {
        return this.keyContainerTable;
    }

    @Override
    public void storeContainerCount(Long count) {
        ReconUtils.upsertGlobalStatsTable(this.sqlConfiguration, this.globalStatsDao, "containerCount", count);
    }

    @Override
    public void incrementContainerCountBy(long count) {
        long containersCount = this.getCountForContainers();
        this.storeContainerCount(containersCount + count);
    }

    @Override
    public void commitBatchOperation(RDBBatchOperation rdbBatchOperation) throws IOException {
        this.containerDbStore.commitBatchOperation((BatchOperation)rdbBatchOperation);
    }

    @Override
    public Map<KeyPrefixContainer, Integer> getContainerForKeyPrefixes(String keyPrefix, long keyVersion) throws IOException {
        LinkedHashMap<KeyPrefixContainer, Integer> containers = new LinkedHashMap<KeyPrefixContainer, Integer>();
        try (TableIterator keyIterator = this.keyContainerTable.iterator();){
            Table.KeyValue keyValue;
            KeyPrefixContainer keyPrefixContainer;
            KeyPrefixContainer seekKey = keyVersion != -1L ? KeyPrefixContainer.get(keyPrefix, keyVersion) : KeyPrefixContainer.get(keyPrefix);
            Table.KeyValue seekKeyValue = (Table.KeyValue)keyIterator.seek((Object)seekKey);
            if (seekKeyValue == null || keyVersion != -1L && ((KeyPrefixContainer)seekKeyValue.getKey()).getKeyVersion() != keyVersion) {
                LinkedHashMap<KeyPrefixContainer, Integer> linkedHashMap = containers;
                return linkedHashMap;
            }
            while (keyIterator.hasNext() && (keyPrefixContainer = (KeyPrefixContainer)(keyValue = (Table.KeyValue)keyIterator.next()).getKey()).getKeyPrefix().equals(keyPrefix)) {
                if (keyPrefixContainer.getContainerId() != -1L && (keyVersion == -1L || keyPrefixContainer.getKeyVersion() == keyVersion)) {
                    containers.put(keyPrefixContainer, (Integer)keyValue.getValue());
                    continue;
                }
                LOG.warn("Null container returned for keyPrefix = {}, keyVersion = {} ", (Object)keyPrefix, (Object)keyVersion);
            }
        }
        return containers;
    }

    private void initializeKeyContainerTable() throws IOException {
        Instant start = Instant.now();
        try (TableIterator iterator = this.containerKeyTable.iterator();){
            long count = 0L;
            while (iterator.hasNext()) {
                Table.KeyValue keyValue = (Table.KeyValue)iterator.next();
                ContainerKeyPrefix containerKeyPrefix = (ContainerKeyPrefix)keyValue.getKey();
                if (!StringUtils.isEmpty((CharSequence)containerKeyPrefix.getKeyPrefix()) && containerKeyPrefix.getContainerId() != -1L) {
                    this.keyContainerTable.put((Object)containerKeyPrefix.toKeyPrefixContainer(), (Object)1);
                }
                ++count;
            }
            long duration = Duration.between(start, Instant.now()).toMillis();
            LOG.info("It took {} seconds to initialized {} records to KEY_CONTAINER table", (Object)((double)duration / 1000.0), (Object)count);
        }
    }
}

