/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.probe.ProbeLogger;

public class ProbeLogger_$logger
extends DelegatingBasicLogger
implements ProbeLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProbeLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ProbeLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void catchingTrace(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.TRACE, throwable, this.catchingTrace$str(), new Object[0]);
    }

    protected String catchingTrace$str() {
        return "Catching";
    }

    @Override
    public final void resourceMatched(Object resource, String pathInfo) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.resourceMatched$str(), resource, (Object)pathInfo);
    }

    protected String resourceMatched$str() {
        return "PROBE-000001: Resource {0} matched for {1}";
    }

    @Override
    public final void processingBeanDeploymentArchive(Object archive) {
        this.log.logv(FQCN, Logger.Level.INFO, (Throwable)null, this.processingBeanDeploymentArchive$str(), archive);
    }

    protected String processingBeanDeploymentArchive$str() {
        return "PROBE-000002: Processing bean deployment archive: {0}";
    }

    @Override
    public final void introspectionProblem(Object bean, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.introspectionProblem$str(), bean);
    }

    protected String introspectionProblem$str() {
        return "PROBE-000003: A problem occured during contextual instance introspection: {0}";
    }

    @Override
    public final void filtersApplied(Object filters) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.filtersApplied$str(), filters);
    }

    protected String filtersApplied$str() {
        return "PROBE-000004: Filters applied: {0}";
    }

    protected String probeNotInitialized$str() {
        return "PROBE-000005: Probe is not properly initialized";
    }

    @Override
    public final IllegalStateException probeNotInitialized() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.probeNotInitialized$str(), new Object[0]));
        ProbeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void invocationMonitorNotAssociatedExcluded(Object beanClass) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.invocationMonitorNotAssociatedExcluded$str(), beanClass);
    }

    protected String invocationMonitorNotAssociatedExcluded$str() {
        return "PROBE-000006: {0} not monitored - excluded";
    }

    @Override
    public final void developmentModeEnabled() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.developmentModeEnabled$str(), new Object[0]);
    }

    protected String developmentModeEnabled$str() {
        return "PROBE-000008: \n=====================================\n Weld Development Mode: ENABLED\n ------------------------------------\n Disable this mode in production - it may have negative impact on performance and/or represent a potential security risk\n=====================================";
    }

    @Override
    public final void monitoringStereotypeAdded(Object bean) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.monitoringStereotypeAdded$str(), bean);
    }

    protected String monitoringStereotypeAdded$str() {
        return "PROBE-000009: @MonitoredComponent stereotype added to {0}";
    }

    @Override
    public final void invocationMonitorNotAssociatedNonProxyableType(Object type) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.invocationMonitorNotAssociatedNonProxyableType$str(), type);
    }

    protected String invocationMonitorNotAssociatedNonProxyableType$str() {
        return "PROBE-000010: {0} not monitored - non-proxyable type";
    }

    @Override
    public final void eventExcluded(Object type) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.eventExcluded$str(), type);
    }

    protected String eventExcluded$str() {
        return "PROBE-000011: Event {0} not monitored - excluded";
    }

    @Override
    public final void monitoringLimitExceeded(Object monitor, Object limit) {
        this.log.logv(FQCN, Logger.Level.DEBUG, (Throwable)null, this.monitoringLimitExceeded$str(), monitor, limit);
    }

    protected String monitoringLimitExceeded$str() {
        return "PROBE-000012: {0} monitoring limit {1} exceed - some old data were removed";
    }

    protected String probeFilterUnableToOperate$str() {
        return "PROBE-000013: Probe filter is not able to operate - missing {0}";
    }

    @Override
    public final IllegalStateException probeFilterUnableToOperate(Class<?> component) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.probeFilterUnableToOperate$str(), component));
        ProbeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String unableToRegisterMBean$str() {
        return "PROBE-000014: Cannot register a Probe MBean {0} for: {1}";
    }

    @Override
    public final IllegalStateException unableToRegisterMBean(Object mbean, Object context, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unableToRegisterMBean$str(), mbean, context), cause);
        ProbeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToUnregisterMBean$str() {
        return "PROBE-000015: Cannot unregister a Probe MBean {0} for: {1}";
    }

    @Override
    public final IllegalStateException unableToUnregisterMBean(Object mbean, Object context, Throwable cause) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unableToUnregisterMBean$str(), mbean, context), cause);
        ProbeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseQueryFilter$str() {
        return "PROBE-000016: Unable to parse query filters: {0}";
    }

    @Override
    public final IllegalArgumentException unableToParseQueryFilter(Object filters) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.unableToParseQueryFilter$str(), filters));
        ProbeLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void requestDenied(Object requestInfo, Object remoteAddr) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.requestDenied$str(), requestInfo, remoteAddr);
    }

    protected String requestDenied$str() {
        return "PROBE-000017: Access to {0} denied for {1}";
    }

    @Override
    public final void invalidExportPath(Object path) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.invalidExportPath$str(), path);
    }

    protected String invalidExportPath$str() {
        return "PROBE-000018: Export path does not exist or is not writable: {0}";
    }

    @Override
    public final void unableToExportData(Object path, Object cause) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.unableToExportData$str(), path, cause);
    }

    protected String unableToExportData$str() {
        return "PROBE-000019: Unable to export data to {0}: {1}";
    }

    @Override
    public final void aroundConstructMonitoringProblem(Object bean, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.WARN, cause, this.aroundConstructMonitoringProblem$str(), bean);
    }

    protected String aroundConstructMonitoringProblem$str() {
        return "PROBE-000020: A problem occured during monitoring of bean instance construction: {0}";
    }

    @Override
    public final void validationReportExported(Object path) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.validationReportExported$str(), path);
    }

    protected String validationReportExported$str() {
        return "PROBE-000021: \n=====================================\n Weld - Deployment Validation: FAILED \n ------------------------------------\n HTML report generated to: \n\n {0} \n=====================================";
    }

    @Override
    public final void cannotUseUnifiedAnnotationToStringConversion(Object path) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)null, this.cannotUseUnifiedAnnotationToStringConversion$str(), path);
    }

    protected String cannotUseUnifiedAnnotationToStringConversion$str() {
        return "PROBE-000022: Probe was not allowed to use customized Annotation toString(), falling back to JDK's default Annotation.toString(). The exception was: {0}";
    }
}

