/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.ratis.thirdparty.io.grpc.CallOptions;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ClientCall;
import org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ForwardingClientCall;
import org.apache.ratis.thirdparty.io.grpc.Metadata;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;

public class GrpcClientInterceptor
implements ClientInterceptor {
    public static final Metadata.Key<String> TRACING_HEADER = Metadata.Key.of((String)"Tracing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                Metadata tracingHeaders = new Metadata();
                tracingHeaders.put(TRACING_HEADER, (Object)TracingUtil.exportCurrentSpan());
                headers.merge(tracingHeaders);
                super.start(responseListener, headers);
            }
        };
    }
}

