/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.ToIntFunction;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ratis.thirdparty.com.google.protobuf.Parser;

public final class Proto3Codec<M extends MessageLite>
implements Codec<M> {
    private static final ConcurrentMap<Class<? extends MessageLite>, Codec<? extends MessageLite>> CODECS = new ConcurrentHashMap<Class<? extends MessageLite>, Codec<? extends MessageLite>>();
    private final Class<M> clazz;
    private final Parser<M> parser;

    public static <T extends MessageLite> Codec<T> get(T t) {
        Codec codec = CODECS.computeIfAbsent(t.getClass(), key -> new Proto3Codec<MessageLite>(t));
        return codec;
    }

    private Proto3Codec(M m) {
        this.clazz = m.getClass();
        this.parser = m.getParserForType();
    }

    @Override
    public Class<M> getTypeClass() {
        return this.clazz;
    }

    @Override
    public boolean supportCodecBuffer() {
        return true;
    }

    private ToIntFunction<ByteBuffer> writeTo(M message, int size) {
        return buffer -> {
            try {
                message.writeTo(CodedOutputStream.newInstance((ByteBuffer)buffer));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to writeTo: message=" + message, e);
            }
            return size;
        };
    }

    @Override
    public CodecBuffer toCodecBuffer(@Nonnull M message, CodecBuffer.Allocator allocator) {
        int size = message.getSerializedSize();
        return ((CodecBuffer)allocator.apply(size)).put(this.writeTo(message, size));
    }

    @Override
    public M fromCodecBuffer(@Nonnull CodecBuffer buffer) throws InvalidProtocolBufferException {
        return (M)((MessageLite)this.parser.parseFrom(buffer.asReadOnlyByteBuffer()));
    }

    @Override
    public byte[] toPersistedFormat(M message) {
        return message.toByteArray();
    }

    @Override
    public M fromPersistedFormat(byte[] bytes) throws InvalidProtocolBufferException {
        return (M)((MessageLite)this.parser.parseFrom(bytes));
    }

    @Override
    public M copyObject(M message) {
        return message;
    }
}

