/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.ozone.common.ChunkBufferImplWithByteBuffer;
import org.apache.hadoop.ozone.common.ChunkBufferImplWithByteBufferList;
import org.apache.hadoop.ozone.common.ChunkBufferToByteString;
import org.apache.hadoop.ozone.common.IncrementalChunkBuffer;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.UncheckedAutoCloseable;

public interface ChunkBuffer
extends ChunkBufferToByteString,
UncheckedAutoCloseable {
    public static ChunkBuffer allocate(int capacity) {
        return ChunkBuffer.allocate(capacity, 0);
    }

    public static ChunkBuffer allocate(int capacity, int increment) {
        if (increment > 0 && increment < capacity) {
            return new IncrementalChunkBuffer(capacity, increment, false);
        }
        CodecBuffer codecBuffer = CodecBuffer.allocateDirect(capacity);
        return new ChunkBufferImplWithByteBuffer(codecBuffer.asWritableByteBuffer(), codecBuffer);
    }

    public static ChunkBuffer wrap(ByteBuffer buffer) {
        return new ChunkBufferImplWithByteBuffer(buffer);
    }

    public static ChunkBuffer wrap(List<ByteBuffer> buffers) {
        Objects.requireNonNull(buffers, "buffers == null");
        if (buffers.size() == 1) {
            return ChunkBuffer.wrap(buffers.get(0));
        }
        return new ChunkBufferImplWithByteBufferList(buffers);
    }

    public int position();

    public int remaining();

    public int limit();

    public ChunkBuffer rewind();

    default public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public ChunkBuffer clear();

    default public void close() {
    }

    public ChunkBuffer put(ByteBuffer var1);

    default public ChunkBuffer put(byte[] b) {
        return this.put(ByteBuffer.wrap(b));
    }

    default public ChunkBuffer put(byte b) {
        byte[] buf = new byte[]{b};
        return this.put(buf, 0, 1);
    }

    default public ChunkBuffer put(byte[] b, int offset, int length) {
        return this.put(ByteBuffer.wrap(b, offset, length));
    }

    default public ChunkBuffer put(ByteString b) {
        return this.put(b.asReadOnlyByteBuffer());
    }

    public ChunkBuffer duplicate(int var1, int var2);

    public Iterable<ByteBuffer> iterate(int var1);

    public List<ByteBuffer> asByteBufferList();

    public long writeTo(GatheringByteChannel var1) throws IOException;
}

