/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.multipart;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.OmKeyResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"openKeyTable", "multipartInfoTable"})
public class S3InitiateMultipartUploadResponse
extends OmKeyResponse {
    private OmMultipartKeyInfo omMultipartKeyInfo;
    private OmKeyInfo omKeyInfo;

    public S3InitiateMultipartUploadResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmMultipartKeyInfo omMultipartKeyInfo, @Nonnull OmKeyInfo omKeyInfo, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.omMultipartKeyInfo = omMultipartKeyInfo;
        this.omKeyInfo = omKeyInfo;
    }

    public S3InitiateMultipartUploadResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String multipartKey = omMetadataManager.getMultipartKey(this.omKeyInfo.getVolumeName(), this.omKeyInfo.getBucketName(), this.omKeyInfo.getKeyName(), this.omMultipartKeyInfo.getUploadID());
        omMetadataManager.getOpenKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)multipartKey, (Object)this.omKeyInfo);
        omMetadataManager.getMultipartInfoTable().putWithBatch(batchOperation, (Object)multipartKey, (Object)this.omMultipartKeyInfo);
    }

    @VisibleForTesting
    public OmMultipartKeyInfo getOmMultipartKeyInfo() {
        return this.omMultipartKeyInfo;
    }

    @VisibleForTesting
    public OmKeyInfo getOmKeyInfo() {
        return this.omKeyInfo;
    }
}

