/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.service.AbstractKeyDeletingService;
import org.apache.hadoop.ozone.om.service.DirectoryDeletingService;
import org.apache.hadoop.ozone.om.service.KeyDeletingService;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.protocol.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotDeletingService
extends AbstractKeyDeletingService {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotDeletingService.class);
    private static final int SNAPSHOT_DELETING_CORE_POOL_SIZE = 1;
    private static final int MIN_ERR_LIMIT_PER_TASK = 1000;
    private final ClientId clientId = ClientId.randomId();
    private final OzoneManager ozoneManager;
    private final OmSnapshotManager omSnapshotManager;
    private final SnapshotChainManager chainManager;
    private final AtomicBoolean suspended;
    private final OzoneConfiguration conf;
    private final AtomicLong successRunCount;
    private final int keyLimitPerTask;
    private final int snapshotDeletionPerTask;
    private final int ratisByteLimit;
    private final long serviceTimeout;

    public SnapshotDeletingService(long interval, long serviceTimeout, OzoneManager ozoneManager) throws IOException {
        super(SnapshotDeletingService.class.getSimpleName(), interval, TimeUnit.MILLISECONDS, 1, serviceTimeout, ozoneManager, null);
        this.ozoneManager = ozoneManager;
        this.omSnapshotManager = ozoneManager.getOmSnapshotManager();
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        this.chainManager = omMetadataManager.getSnapshotChainManager();
        this.successRunCount = new AtomicLong(0L);
        this.suspended = new AtomicBoolean(false);
        this.conf = ozoneManager.getConfiguration();
        this.snapshotDeletionPerTask = this.conf.getInt("ozone.snapshot.deleting.limit.per.task", 10);
        int limit = (int)this.conf.getStorageSize("ozone.om.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        this.ratisByteLimit = (int)((double)limit * 0.9);
        this.keyLimitPerTask = this.conf.getInt("ozone.snapshot.key.deleting.limit.per.task", 20000);
        this.serviceTimeout = serviceTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void waitForKeyDeletingService() throws InterruptedException {
        KeyDeletingService keyDeletingService;
        KeyDeletingService keyDeletingService2 = keyDeletingService = this.getOzoneManager().getKeyManager().getDeletingService();
        synchronized (keyDeletingService2) {
            while (keyDeletingService.isRunningOnAOS()) {
                ((Object)((Object)keyDeletingService)).wait(this.serviceTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void waitForDirDeletingService() throws InterruptedException {
        DirectoryDeletingService directoryDeletingService;
        DirectoryDeletingService directoryDeletingService2 = directoryDeletingService = this.getOzoneManager().getKeyManager().getDirDeletingService();
        synchronized (directoryDeletingService2) {
            while (directoryDeletingService.isRunningOnAOS()) {
                ((Object)((Object)directoryDeletingService)).wait(this.serviceTimeout);
            }
        }
    }

    @VisibleForTesting
    boolean shouldIgnoreSnapshot(SnapshotInfo snapInfo) throws IOException {
        SnapshotInfo.SnapshotStatus snapshotStatus = snapInfo.getSnapshotStatus();
        return snapshotStatus != SnapshotInfo.SnapshotStatus.SNAPSHOT_DELETED || !OmSnapshotManager.areSnapshotChangesFlushedToDB(this.getOzoneManager().getMetadataManager(), snapInfo);
    }

    public static boolean isBlockLocationInfoSame(OmKeyInfo prevKeyInfo, OmKeyInfo deletedKeyInfo) {
        if (prevKeyInfo == null && deletedKeyInfo == null) {
            LOG.debug("Both prevKeyInfo and deletedKeyInfo are null.");
            return true;
        }
        if (prevKeyInfo == null || deletedKeyInfo == null) {
            LOG.debug("prevKeyInfo: '{}' or deletedKeyInfo: '{}' is null.", (Object)prevKeyInfo, (Object)deletedKeyInfo);
            return false;
        }
        if (prevKeyInfo.isHsync() && deletedKeyInfo.isHsync()) {
            return true;
        }
        if (prevKeyInfo.getKeyLocationVersions().size() != deletedKeyInfo.getKeyLocationVersions().size()) {
            return false;
        }
        OmKeyLocationInfoGroup deletedOmKeyLocation = deletedKeyInfo.getLatestVersionLocations();
        OmKeyLocationInfoGroup prevOmKeyLocation = prevKeyInfo.getLatestVersionLocations();
        if (deletedOmKeyLocation == null || prevOmKeyLocation == null) {
            return false;
        }
        List deletedLocationList = deletedOmKeyLocation.getLocationList();
        List prevLocationList = prevOmKeyLocation.getLocationList();
        if (deletedLocationList.size() != prevLocationList.size()) {
            return false;
        }
        int idx = 0;
        while (idx < deletedLocationList.size()) {
            OmKeyLocationInfo prevLocationInfo;
            OmKeyLocationInfo deletedLocationInfo = (OmKeyLocationInfo)deletedLocationList.get(idx);
            if (!deletedLocationInfo.hasSameBlockAs((Object)(prevLocationInfo = (OmKeyLocationInfo)prevLocationList.get(idx)))) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new SnapshotDeletingTask());
        return queue;
    }

    private boolean shouldRun() {
        return !this.suspended.get() && this.ozoneManager.isLeaderReady();
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    public long getSuccessfulRunCount() {
        return this.successRunCount.get();
    }

    @VisibleForTesting
    public void setSuccessRunCount(long num) {
        this.successRunCount.getAndSet(num);
    }

    private class SnapshotDeletingTask
    implements BackgroundTask {
        private SnapshotDeletingTask() {
        }

        public BackgroundTaskResult call() throws InterruptedException {
            if (!SnapshotDeletingService.this.shouldRun()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            SnapshotDeletingService.this.getRunCount().incrementAndGet();
            try {
                int remaining = SnapshotDeletingService.this.keyLimitPerTask;
                Iterator<UUID> iterator = SnapshotDeletingService.this.chainManager.iterator(true);
                ArrayList<String> snapshotsToBePurged = new ArrayList<String>();
                long snapshotLimit = SnapshotDeletingService.this.snapshotDeletionPerTask;
                while (iterator.hasNext() && snapshotLimit > 0L && remaining > 0) {
                    SnapshotInfo snapInfo = SnapshotUtils.getSnapshotInfo(SnapshotDeletingService.this.ozoneManager, SnapshotDeletingService.this.chainManager, iterator.next());
                    if (SnapshotDeletingService.this.shouldIgnoreSnapshot(snapInfo)) continue;
                    LOG.info("Started Snapshot Deletion Processing for snapshot : {}", (Object)snapInfo.getTableKey());
                    SnapshotInfo nextSnapshot = SnapshotUtils.getNextSnapshot(SnapshotDeletingService.this.ozoneManager, SnapshotDeletingService.this.chainManager, snapInfo);
                    if (nextSnapshot != null && nextSnapshot.getSnapshotStatus() != SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE) continue;
                    if (nextSnapshot == null) {
                        SnapshotDeletingService.this.waitForKeyDeletingService();
                        SnapshotDeletingService.this.waitForDirDeletingService();
                    }
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (ReferenceCounted<OmSnapshot> snapshot = SnapshotDeletingService.this.omSnapshotManager.getSnapshot(snapInfo.getVolumeName(), snapInfo.getBucketName(), snapInfo.getName());){
                        KeyManager snapshotKeyManager = snapshot.get().getKeyManager();
                        int moveCount = 0;
                        List<Table.KeyValue<String, List<OmKeyInfo>>> deletedKeyEntries = snapshotKeyManager.getDeletedKeyEntries(snapInfo.getVolumeName(), snapInfo.getBucketName(), null, remaining);
                        List<Table.KeyValue<String, OmKeyInfo>> deletedDirEntries = snapshotKeyManager.getDeletedDirEntries(snapInfo.getVolumeName(), snapInfo.getBucketName(), remaining - (moveCount += deletedKeyEntries.size()));
                        List<Table.KeyValue<String, String>> renameEntries = snapshotKeyManager.getRenamesKeyEntries(snapInfo.getVolumeName(), snapInfo.getBucketName(), null, remaining - (moveCount += deletedDirEntries.size()));
                        if ((moveCount += renameEntries.size()) > 0) {
                            ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedKeys = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>(deletedKeyEntries.size());
                            ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedDirs = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>(deletedDirEntries.size());
                            ArrayList<HddsProtos.KeyValue> renameKeys = new ArrayList<HddsProtos.KeyValue>(renameEntries.size());
                            for (Table.KeyValue<String, List<OmKeyInfo>> keyValue : deletedKeyEntries) {
                                deletedKeys.add(OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.newBuilder().setKey((String)keyValue.getKey()).addAllKeyInfos((Iterable)((List)keyValue.getValue()).stream().map(val -> val.getProtobuf(ClientVersion.CURRENT_VERSION)).collect(Collectors.toList())).build());
                            }
                            for (Table.KeyValue<String, List<OmKeyInfo>> keyValue : deletedDirEntries) {
                                deletedDirs.add(OzoneManagerProtocolProtos.SnapshotMoveKeyInfos.newBuilder().setKey((String)keyValue.getKey()).addKeyInfos(((OmKeyInfo)keyValue.getValue()).getProtobuf(ClientVersion.CURRENT_VERSION)).build());
                            }
                            for (Table.KeyValue keyValue : renameEntries) {
                                renameKeys.add(HddsProtos.KeyValue.newBuilder().setKey((String)keyValue.getKey()).setValue((String)keyValue.getValue()).build());
                            }
                            this.submitSnapshotMoveDeletedKeys(snapInfo, deletedKeys, renameKeys, deletedDirs);
                            remaining -= moveCount;
                        } else {
                            snapshotsToBePurged.add(snapInfo.getTableKey());
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    SnapshotDeletingService.this.successRunCount.incrementAndGet();
                    --snapshotLimit;
                }
                if (!snapshotsToBePurged.isEmpty()) {
                    this.submitSnapshotPurgeRequest(snapshotsToBePurged);
                }
            }
            catch (IOException e) {
                LOG.error("Error while running Snapshot Deleting Service", (Throwable)e);
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        private void submitSnapshotPurgeRequest(List<String> purgeSnapshotKeys) throws InterruptedException {
            if (!purgeSnapshotKeys.isEmpty()) {
                OzoneManagerProtocolProtos.SnapshotPurgeRequest snapshotPurgeRequest = OzoneManagerProtocolProtos.SnapshotPurgeRequest.newBuilder().addAllSnapshotDBKeys(purgeSnapshotKeys).build();
                OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SnapshotPurge).setSnapshotPurgeRequest(snapshotPurgeRequest).setClientId(SnapshotDeletingService.this.clientId.toString()).build();
                Throwable throwable = null;
                Object var5_6 = null;
                try (BootstrapStateHandler.Lock lock = SnapshotDeletingService.this.getBootstrapStateLock().lock();){
                    this.submitRequest(omRequest);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }

        private void submitSnapshotMoveDeletedKeys(SnapshotInfo snapInfo, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedKeys, List<HddsProtos.KeyValue> renamedList, List<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> dirsToMove) throws InterruptedException {
            OzoneManagerProtocolProtos.SnapshotMoveTableKeysRequest.Builder moveDeletedKeysBuilder = OzoneManagerProtocolProtos.SnapshotMoveTableKeysRequest.newBuilder().setFromSnapshotID(HddsUtils.toProtobuf((UUID)snapInfo.getSnapshotId()));
            OzoneManagerProtocolProtos.SnapshotMoveTableKeysRequest moveDeletedKeys = moveDeletedKeysBuilder.addAllDeletedKeys(deletedKeys).addAllRenamedKeys(renamedList).addAllDeletedDirs(dirsToMove).build();
            if (SnapshotDeletingService.this.isBufferLimitCrossed(SnapshotDeletingService.this.ratisByteLimit, 0, moveDeletedKeys.getSerializedSize())) {
                int remaining = 1000;
                deletedKeys = deletedKeys.subList(0, Math.min(remaining, deletedKeys.size()));
                renamedList = renamedList.subList(0, Math.min(remaining -= deletedKeys.size(), renamedList.size()));
                dirsToMove = dirsToMove.subList(0, Math.min(remaining -= renamedList.size(), dirsToMove.size()));
                moveDeletedKeys = moveDeletedKeysBuilder.addAllDeletedKeys(deletedKeys).addAllRenamedKeys(renamedList).addAllDeletedDirs(dirsToMove).build();
            }
            OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SnapshotMoveTableKeys).setSnapshotMoveTableKeysRequest(moveDeletedKeys).setClientId(SnapshotDeletingService.this.clientId.toString()).build();
            Throwable throwable = null;
            Object var9_11 = null;
            try (BootstrapStateHandler.Lock lock = SnapshotDeletingService.this.getBootstrapStateLock().lock();){
                this.submitRequest(omRequest);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        private void submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
            try {
                OzoneManagerProtocolProtos.Status status = OzoneManagerRatisUtils.submitRequest(SnapshotDeletingService.this.ozoneManager, omRequest, SnapshotDeletingService.this.clientId, SnapshotDeletingService.this.getRunCount().get()).getStatus();
                if (!Objects.equals(status, OzoneManagerProtocolProtos.Status.OK)) {
                    LOG.error("Request: {} failed with an status: {}. Will retry in the next run.", (Object)omRequest, (Object)status);
                }
            }
            catch (ServiceException e) {
                LOG.error("Request: {} fired by SnapshotDeletingService failed. Will retry in the next run", (Object)omRequest, (Object)e);
            }
        }
    }
}

