/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder.util;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.ozone.erasurecode.ECChunk;

@InterfaceAudience.Private
public final class DumpUtil {
    private static final String HEX_CHARS_STR = "0123456789ABCDEF";
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    private DumpUtil() {
    }

    public static String bytesToHex(byte[] bytes, int limit) {
        if (limit <= 0 || limit > bytes.length) {
            limit = bytes.length;
        }
        int len = limit * 2;
        len += limit;
        char[] hexChars = new char[len += 2];
        hexChars[0] = 48;
        hexChars[1] = 120;
        for (int j = 0; j < limit; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 3 + 2] = HEX_CHARS[v >>> 4];
            hexChars[j * 3 + 3] = HEX_CHARS[v & 0xF];
            hexChars[j * 3 + 4] = 32;
        }
        return new String(hexChars);
    }

    public static void dumpMatrix(byte[] matrix, int numDataUnits, int numAllUnits) {
        for (int i = 0; i < numDataUnits; ++i) {
            for (int j = 0; j < numAllUnits; ++j) {
                System.out.print(" ");
                System.out.print(0xFF & matrix[i * numAllUnits + j]);
            }
            System.out.println();
        }
    }

    public static void dumpChunks(String header, ECChunk[] chunks) {
        System.out.println();
        System.out.println(header);
        for (ECChunk chunk : chunks) {
            DumpUtil.dumpChunk(chunk);
        }
        System.out.println();
    }

    public static void dumpChunk(ECChunk chunk) {
        String str;
        if (chunk == null) {
            str = "<EMPTY>";
        } else {
            byte[] bytes = chunk.toBytesArray();
            str = DumpUtil.bytesToHex(bytes, 16);
        }
        System.out.println(str);
    }
}

