/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import java.io.Closeable;
import java.util.EnumMap;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.util.MetricUtil;

@InterfaceAudience.Private
@Metrics(about="Storage Container DataNode Metrics", context="dfs")
public class ContainerMetrics
implements Closeable {
    public static final String STORAGE_CONTAINER_METRICS = "StorageContainerMetrics";
    @Metric
    private MutableCounterLong numOps;
    @Metric
    private MutableCounterLong containerDeleteFailedNonEmpty;
    @Metric
    private MutableCounterLong containerDeleteFailedBlockCountNotZero;
    @Metric
    private MutableCounterLong containerForceDelete;
    @Metric
    private MutableCounterLong numReadStateMachine;
    @Metric
    private MutableCounterLong bytesReadStateMachine;
    private final EnumMap<ContainerProtos.Type, MutableCounterLong> numOpsArray;
    private final EnumMap<ContainerProtos.Type, MutableCounterLong> opsBytesArray;
    private final EnumMap<ContainerProtos.Type, MutableRate> opsLatency;
    private final EnumMap<ContainerProtos.Type, MutableQuantiles[]> opsLatQuantiles;
    private MetricsRegistry registry = null;

    public ContainerMetrics(int[] intervals) {
        int len = intervals.length;
        MutableQuantiles[] latQuantiles = new MutableQuantiles[len];
        this.numOpsArray = new EnumMap(ContainerProtos.Type.class);
        this.opsBytesArray = new EnumMap(ContainerProtos.Type.class);
        this.opsLatency = new EnumMap(ContainerProtos.Type.class);
        this.opsLatQuantiles = new EnumMap(ContainerProtos.Type.class);
        this.registry = new MetricsRegistry(STORAGE_CONTAINER_METRICS);
        for (ContainerProtos.Type type : ContainerProtos.Type.values()) {
            this.numOpsArray.put(type, this.registry.newCounter("num" + type, "number of " + type + " ops", 0L));
            this.opsBytesArray.put(type, this.registry.newCounter("bytes" + type, "bytes used by " + type + "op", 0L));
            this.opsLatency.put(type, this.registry.newRate("latencyNs" + type, type + " op"));
            for (int j = 0; j < len; ++j) {
                int interval = intervals[j];
                String quantileName = type + "Nanos" + interval + "s";
                latQuantiles[j] = this.registry.newQuantiles(quantileName, "latency of Container ops", "ops", "latencyNs", interval);
            }
            this.opsLatQuantiles.put(type, latQuantiles);
        }
    }

    public static ContainerMetrics create(ConfigurationSource conf) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        int[] intervals = conf.getInts("hdds.metrics.percentiles.intervals");
        return (ContainerMetrics)ms.register(STORAGE_CONTAINER_METRICS, "Storage Container Node Metrics", (Object)new ContainerMetrics(intervals));
    }

    public static void remove() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(STORAGE_CONTAINER_METRICS);
    }

    @Override
    public void close() {
        this.opsLatQuantiles.values().forEach(MetricUtil::stop);
    }

    public void incContainerOpsMetrics(ContainerProtos.Type type) {
        this.numOps.incr();
        this.numOpsArray.get(type).incr();
    }

    public void incContainerOpsLatencies(ContainerProtos.Type type, long latencyNs) {
        this.opsLatency.get(type).add(latencyNs);
        for (MutableQuantiles q : this.opsLatQuantiles.get(type)) {
            q.add(latencyNs);
        }
    }

    public void incContainerBytesStats(ContainerProtos.Type type, long bytes) {
        this.opsBytesArray.get(type).incr(bytes);
    }

    public void incContainerDeleteFailedBlockCountNotZero() {
        this.containerDeleteFailedBlockCountNotZero.incr();
    }

    public void incContainerDeleteFailedNonEmpty() {
        this.containerDeleteFailedNonEmpty.incr();
    }

    public void incContainersForceDelete() {
        this.containerForceDelete.incr();
    }

    public long getContainerDeleteFailedNonEmpty() {
        return this.containerDeleteFailedNonEmpty.value();
    }

    public long getContainerDeleteFailedBlockCountNotZero() {
        return this.containerDeleteFailedBlockCountNotZero.value();
    }

    public long getContainerForceDelete() {
        return this.containerForceDelete.value();
    }

    public void incNumReadStateMachine() {
        this.numReadStateMachine.incr();
    }

    public long getNumReadStateMachine() {
        return this.numReadStateMachine.value();
    }

    public void incBytesReadStateMachine(long bytes) {
        this.bytesReadStateMachine.incr(bytes);
    }

    public long getBytesReadStateMachine() {
        return this.bytesReadStateMachine.value();
    }
}

