/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.IntraDatanodeProtocolServiceGrpc;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.ozone.container.replication.ContainerImporter;
import org.apache.hadoop.ozone.container.replication.ContainerReplicationSource;
import org.apache.hadoop.ozone.container.replication.CopyContainerCompression;
import org.apache.hadoop.ozone.container.replication.CopyContainerResponseStream;
import org.apache.hadoop.ozone.container.replication.SendContainerRequestHandler;
import org.apache.ratis.grpc.util.ZeroCopyMessageMarshaller;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.apache.ratis.thirdparty.io.grpc.ServerCallHandler;
import org.apache.ratis.thirdparty.io.grpc.ServerServiceDefinition;
import org.apache.ratis.thirdparty.io.grpc.stub.CallStreamObserver;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcReplicationService
extends IntraDatanodeProtocolServiceGrpc.IntraDatanodeProtocolServiceImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcReplicationService.class);
    static final int BUFFER_SIZE = 0x100000;
    private final ContainerReplicationSource source;
    private final ContainerImporter importer;
    private final ZeroCopyMessageMarshaller<ContainerProtos.SendContainerRequest> sendContainerZeroCopyMessageMarshaller;
    private final ZeroCopyMessageMarshaller<ContainerProtos.CopyContainerRequestProto> copyContainerZeroCopyMessageMarshaller;

    public GrpcReplicationService(ContainerReplicationSource source, ContainerImporter importer) {
        this.source = source;
        this.importer = importer;
        this.sendContainerZeroCopyMessageMarshaller = new ZeroCopyMessageMarshaller((MessageLite)ContainerProtos.SendContainerRequest.getDefaultInstance());
        this.copyContainerZeroCopyMessageMarshaller = new ZeroCopyMessageMarshaller((MessageLite)ContainerProtos.CopyContainerRequestProto.getDefaultInstance());
    }

    public ServerServiceDefinition bindServiceWithZeroCopy() {
        ServerServiceDefinition orig = super.bindService();
        HashSet<String> methodNames = new HashSet<String>();
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)orig.getServiceDescriptor().getName());
        MethodDescriptor uploadMethod = IntraDatanodeProtocolServiceGrpc.getUploadMethod();
        GrpcReplicationService.addZeroCopyMethod(orig, builder, uploadMethod, this.sendContainerZeroCopyMessageMarshaller);
        methodNames.add(uploadMethod.getFullMethodName());
        MethodDescriptor downloadMethod = IntraDatanodeProtocolServiceGrpc.getDownloadMethod();
        GrpcReplicationService.addZeroCopyMethod(orig, builder, downloadMethod, this.copyContainerZeroCopyMessageMarshaller);
        methodNames.add(downloadMethod.getFullMethodName());
        orig.getMethods().stream().filter(x -> !methodNames.contains(x.getMethodDescriptor().getFullMethodName())).forEach(arg_0 -> ((ServerServiceDefinition.Builder)builder).addMethod(arg_0));
        return builder.build();
    }

    private static <Req extends MessageLite, Resp> void addZeroCopyMethod(ServerServiceDefinition orig, ServerServiceDefinition.Builder newServiceBuilder, MethodDescriptor<Req, Resp> origMethod, ZeroCopyMessageMarshaller<Req> zeroCopyMarshaller) {
        MethodDescriptor newMethod = origMethod.toBuilder().setRequestMarshaller(zeroCopyMarshaller).build();
        ServerCallHandler serverCallHandler = orig.getMethod(newMethod.getFullMethodName()).getServerCallHandler();
        newServiceBuilder.addMethod(newMethod, serverCallHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(ContainerProtos.CopyContainerRequestProto request, StreamObserver<ContainerProtos.CopyContainerResponseProto> responseObserver) {
        long containerID = request.getContainerID();
        CopyContainerCompression compression = CopyContainerCompression.fromProto(request.getCompression());
        LOG.info("Streaming container data ({}) to other datanode with compression {}", (Object)containerID, (Object)compression);
        CopyContainerResponseStream outputStream = null;
        try {
            outputStream = new CopyContainerResponseStream((CallStreamObserver<ContainerProtos.CopyContainerResponseProto>)((CallStreamObserver)responseObserver), containerID, 0x100000);
            this.source.copyData(containerID, outputStream, compression);
        }
        catch (IOException e) {
            try {
                LOG.warn("Error streaming container {}", (Object)containerID, (Object)e);
                responseObserver.onError((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{outputStream});
                this.copyContainerZeroCopyMessageMarshaller.release((MessageLite)request);
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{outputStream});
            this.copyContainerZeroCopyMessageMarshaller.release((MessageLite)request);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{outputStream});
        this.copyContainerZeroCopyMessageMarshaller.release((MessageLite)request);
    }

    public StreamObserver<ContainerProtos.SendContainerRequest> upload(StreamObserver<ContainerProtos.SendContainerResponse> responseObserver) {
        return new SendContainerRequestHandler(this.importer, responseObserver, this.sendContainerZeroCopyMessageMarshaller);
    }
}

