/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.lease.LeaseAlreadyExistException;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseContainerEventHandler
implements EventHandler<ContainerID> {
    public static final Logger LOG = LoggerFactory.getLogger(CloseContainerEventHandler.class);
    private final PipelineManager pipelineManager;
    private final ContainerManager containerManager;
    private final SCMContext scmContext;
    private final LeaseManager<Object> leaseManager;
    private final long timeout;

    public CloseContainerEventHandler(PipelineManager pipelineManager, ContainerManager containerManager, SCMContext scmContext, @Nullable LeaseManager<Object> leaseManager, long timeout) {
        this.pipelineManager = pipelineManager;
        this.containerManager = containerManager;
        this.scmContext = scmContext;
        this.leaseManager = leaseManager;
        this.timeout = timeout;
    }

    public void onMessage(ContainerID containerID, EventPublisher publisher) {
        if (!this.scmContext.isLeader()) {
            LOG.info("Skip close container {} since current SCM is not leader.", (Object)containerID);
            return;
        }
        try {
            ContainerInfo container;
            LOG.info("Close container Event triggered for container : {}, current state: {}", (Object)containerID, (Object)this.containerManager.getContainer(containerID).getState());
            if (this.containerManager.getContainer(containerID).getState() == HddsProtos.LifeCycleState.OPEN) {
                this.containerManager.updateContainerState(containerID, HddsProtos.LifeCycleEvent.FINALIZE);
            }
            if ((container = this.containerManager.getContainer(containerID)).getState() == HddsProtos.LifeCycleState.CLOSING) {
                boolean force = false;
                if (container.getReplicationConfig().getReplicationType() != HddsProtos.ReplicationType.RATIS) {
                    force = true;
                }
                CloseContainerCommand command = new CloseContainerCommand(containerID.getId(), container.getPipelineID(), force);
                command.setTerm(this.scmContext.getTermOfLeader());
                command.setEncodedToken(this.getContainerToken(containerID));
                if (null != this.leaseManager) {
                    try {
                        this.leaseManager.acquire((Object)command, this.timeout, () -> this.lambda$onMessage$0(publisher, container, (SCMCommand)command));
                    }
                    catch (LeaseAlreadyExistException ex) {
                        LOG.debug("Close container {} in {} state already in queue.", (Object)containerID, (Object)container.getState());
                    }
                    catch (Exception ex) {
                        LOG.error("Error while scheduling close", (Throwable)ex);
                    }
                } else {
                    this.triggerCloseCallback(publisher, container, (SCMCommand<?>)command);
                }
            } else {
                LOG.debug("Cannot close container {}, which is in {} state.", (Object)containerID, (Object)container.getState());
            }
        }
        catch (NotLeaderException nle) {
            LOG.warn("Skip sending close container command, since current SCM is not leader.", (Throwable)nle);
        }
        catch (IOException | InvalidStateTransitionException ex) {
            LOG.error("Failed to close the container {}.", (Object)containerID, (Object)ex);
        }
    }

    private Void triggerCloseCallback(EventPublisher publisher, ContainerInfo container, SCMCommand<?> command) throws ContainerNotFoundException {
        this.getNodes(container).forEach(node -> publisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(node.getUuid(), command)));
        return null;
    }

    private String getContainerToken(ContainerID containerID) {
        if (this.scmContext.getScm() instanceof StorageContainerManager) {
            StorageContainerManager scm = (StorageContainerManager)this.scmContext.getScm();
            return scm.getContainerTokenGenerator().generateEncodedToken(containerID);
        }
        return "";
    }

    private List<DatanodeDetails> getNodes(ContainerInfo container) throws ContainerNotFoundException {
        try {
            return this.pipelineManager.getPipeline(container.getPipelineID()).getNodes();
        }
        catch (PipelineNotFoundException ex) {
            return this.containerManager.getContainerReplicas(container.containerID()).stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList());
        }
    }

    private /* synthetic */ Void lambda$onMessage$0(EventPublisher publisher, ContainerInfo container, SCMCommand command) throws Exception {
        return this.triggerCloseCallback(publisher, container, command);
    }
}

