/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.token;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Objects;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.token.RenewerOption;
import org.apache.hadoop.ozone.shell.token.TokenOption;
import org.apache.hadoop.security.token.Token;
import picocli.CommandLine;

@CommandLine.Command(name="get", description={"get a delegation token."})
public class GetTokenHandler
extends Handler {
    @CommandLine.Parameters(arity="0..1", description={"Ozone URI could either be a full URI or short URI.\nFull URI should start with o3://, in case of non-HA\nclusters it should be followed by the host name and\noptionally the port number. In case of HA clusters\nthe service id should be used. Service id provides a\nlogical name for multiple hosts and it is defined\nin the property ozone.om.service.ids.\nExample of a full URI with host name and port number\nfor a key:\no3://omhostname:9862/vol1/bucket1/key1\nWith a service id for a volume:\no3://omserviceid/vol1/\nShort URI should start from the volume.\nExample of a short URI for a bucket:\nvol1/bucket1\nAny unspecified information will be identified from\nthe config files.\n"})
    private String uri;
    @CommandLine.Mixin
    private RenewerOption renewer;
    @CommandLine.Mixin
    private TokenOption tokenFile;

    @Override
    protected OzoneAddress getAddress() throws OzoneClientException {
        return new OzoneAddress(this.uri);
    }

    @Override
    protected boolean isApplicable() {
        return this.securityEnabled();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        Token token = client.getObjectStore().getDelegationToken(new Text(this.renewer.getValue()));
        if (Objects.isNull(token)) {
            this.err().println("Error: Get delegation token operation failed. Check OzoneManager logs for more details.");
        } else {
            this.out().println("Successfully get token for service " + token.getService());
            this.out().println(token.toString());
            this.tokenFile.persistToken((Token<OzoneTokenIdentifier>)token);
        }
        Path tokenFilePath = Paths.get(this.tokenFile.getTokenFilePath(), new String[0]);
        Files.setPosixFilePermissions(tokenFilePath, PosixFilePermissions.fromString("rw-------"));
    }
}

