/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackgroundService {
    protected static final Logger LOG = LoggerFactory.getLogger(BackgroundService.class);
    private ScheduledThreadPoolExecutor exec;
    private ThreadGroup threadGroup;
    private final String serviceName;
    private long interval;
    private volatile long serviceTimeoutInNanos;
    private TimeUnit unit;
    private final int threadPoolSize;
    private final String threadNamePrefix;
    private final PeriodicalTask service;
    private CompletableFuture<Void> future;

    public BackgroundService(String serviceName, long interval, TimeUnit unit, int threadPoolSize, long serviceTimeout) {
        this(serviceName, interval, unit, threadPoolSize, serviceTimeout, "");
    }

    public BackgroundService(String serviceName, long interval, TimeUnit unit, int threadPoolSize, long serviceTimeout, String threadNamePrefix) {
        this.interval = interval;
        this.unit = unit;
        this.serviceName = serviceName;
        this.serviceTimeoutInNanos = TimeDuration.valueOf((long)serviceTimeout, (TimeUnit)unit).toLong(TimeUnit.NANOSECONDS);
        this.threadPoolSize = threadPoolSize;
        this.threadNamePrefix = threadNamePrefix;
        this.initExecutorAndThreadGroup();
        this.service = new PeriodicalTask();
        this.future = CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> getFuture() {
        return this.future;
    }

    @VisibleForTesting
    public synchronized ExecutorService getExecutorService() {
        return this.exec;
    }

    public synchronized void setPoolSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Pool size must be positive.");
        }
        this.exec.setCorePoolSize(size);
    }

    public synchronized void setServiceTimeoutInNanos(long newTimeout) {
        LOG.info("{} timeout is set to {} {}", new Object[]{this.serviceName, newTimeout, TimeUnit.NANOSECONDS.name().toLowerCase()});
        this.serviceTimeoutInNanos = newTimeout;
    }

    @VisibleForTesting
    public int getThreadCount() {
        return this.threadGroup.activeCount();
    }

    @VisibleForTesting
    public void runPeriodicalTaskNow() throws Exception {
        BackgroundTaskQueue tasks = this.getTasks();
        while (!tasks.isEmpty()) {
            tasks.poll().call();
        }
        this.execTaskCompletion();
    }

    public synchronized void start() {
        if (this.exec == null || this.exec.isShutdown() || this.exec.isTerminated()) {
            this.initExecutorAndThreadGroup();
        }
        LOG.info("Starting service {} with interval {} {}", new Object[]{this.serviceName, this.interval, this.unit.name().toLowerCase()});
        this.exec.scheduleWithFixedDelay(this.service, 0L, this.interval, this.unit);
    }

    protected synchronized void setInterval(long newInterval, TimeUnit newUnit) {
        this.interval = newInterval;
        this.unit = newUnit;
    }

    protected synchronized long getIntervalMillis() {
        return this.unit.toMillis(this.interval);
    }

    public abstract BackgroundTaskQueue getTasks();

    protected void execTaskCompletion() {
    }

    public synchronized void shutdown() {
        LOG.info("Shutting down service {}", (Object)this.serviceName);
        this.exec.shutdown();
        try {
            if (!this.exec.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.exec.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.exec.shutdownNow();
        }
        if (this.threadGroup.activeCount() == 0 && !this.threadGroup.isDestroyed()) {
            this.threadGroup.destroy();
        }
    }

    private void initExecutorAndThreadGroup() {
        this.threadGroup = new ThreadGroup(this.serviceName);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setThreadFactory(r -> new Thread(this.threadGroup, r)).setDaemon(true).setNameFormat(this.threadNamePrefix + this.serviceName + "#%d").build();
        this.exec = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(this.threadPoolSize, threadFactory);
    }

    public class PeriodicalTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BackgroundTaskQueue tasks;
            try {
                BackgroundService.this.future.join();
            }
            catch (RuntimeException e2) {
                LOG.error("Background service execution failed.", (Throwable)e2);
            }
            finally {
                BackgroundService.this.execTaskCompletion();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running background service : {}", (Object)BackgroundService.this.serviceName);
            }
            if ((tasks = BackgroundService.this.getTasks()).isEmpty()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Number of background tasks to execute : {}", (Object)tasks.size());
            }
            BackgroundService backgroundService = BackgroundService.this;
            synchronized (backgroundService) {
                while (!tasks.isEmpty()) {
                    BackgroundTask task = tasks.poll();
                    BackgroundService.this.future = (CompletableFuture)BackgroundService.this.future.thenCombine(CompletableFuture.runAsync(() -> {
                        long endTime;
                        long startTime;
                        block7: {
                            startTime = System.nanoTime();
                            try {
                                BackgroundTaskResult result = task.call();
                                if (!LOG.isDebugEnabled()) break block7;
                                LOG.debug("task execution result size {}", (Object)result.getSize());
                            }
                            catch (Throwable e) {
                                block8: {
                                    try {
                                        LOG.error("Background task execution failed", e);
                                        if (!(e instanceof Error)) break block8;
                                        throw (Error)e;
                                    }
                                    catch (Throwable throwable) {
                                        long endTime2 = System.nanoTime();
                                        if (endTime2 - startTime > BackgroundService.this.serviceTimeoutInNanos) {
                                            LOG.warn("{} Background task execution took {}ns > {}ns(timeout)", new Object[]{BackgroundService.this.serviceName, endTime2 - startTime, BackgroundService.this.serviceTimeoutInNanos});
                                        }
                                        throw throwable;
                                    }
                                }
                                long endTime3 = System.nanoTime();
                                if (endTime3 - startTime > BackgroundService.this.serviceTimeoutInNanos) {
                                    LOG.warn("{} Background task execution took {}ns > {}ns(timeout)", new Object[]{BackgroundService.this.serviceName, endTime3 - startTime, BackgroundService.this.serviceTimeoutInNanos});
                                }
                            }
                        }
                        if ((endTime = System.nanoTime()) - startTime > BackgroundService.this.serviceTimeoutInNanos) {
                            LOG.warn("{} Background task execution took {}ns > {}ns(timeout)", new Object[]{BackgroundService.this.serviceName, endTime - startTime, BackgroundService.this.serviceTimeoutInNanos});
                        }
                    }, BackgroundService.this.exec).exceptionally(e -> null), (Void1, Void2) -> null);
                }
            }
        }
    }
}

