/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.HASecurityUtils;
import org.apache.hadoop.hdds.scm.ha.SCMRatisRequest;
import org.apache.hadoop.hdds.scm.ha.SCMRatisResponse;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.metadata.Replicate;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMHAInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SCMHAInvocationHandler.class);
    private final SCMRatisProtocol.RequestType requestType;
    private final Object localHandler;
    private final SCMRatisServer ratisHandler;

    public SCMHAInvocationHandler(SCMRatisProtocol.RequestType requestType, Object localHandler, SCMRatisServer ratisHandler) {
        this.requestType = requestType;
        this.localHandler = localHandler;
        this.ratisHandler = ratisHandler;
        if (ratisHandler != null) {
            ratisHandler.registerStateMachineHandler(requestType, localHandler);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws SCMException {
        Object result;
        Object[] convertedArgs = args == null ? new Object[]{} : args;
        long startTime = Time.monotonicNow();
        Object object = result = this.ratisHandler != null && method.isAnnotationPresent(Replicate.class) ? this.invokeRatis(method, convertedArgs) : this.invokeLocal(method, convertedArgs);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Call: {} took {} ms", (Object)method, (Object)(Time.monotonicNow() - startTime));
        }
        return result;
    }

    private Object invokeLocal(Method method, Object[] args) throws SCMException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Invoking method {} on target {} with arguments {}", new Object[]{method, this.localHandler, args});
        }
        try {
            return method.invoke(this.localHandler, args);
        }
        catch (Exception e) {
            throw SCMHAInvocationHandler.translateException(e);
        }
    }

    private Object invokeRatis(Method method, Object[] args) throws SCMException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Invoking method {} on target {}", (Object)method, (Object)this.ratisHandler);
        }
        try {
            switch (method.getAnnotation(Replicate.class).invocationType()) {
                case CLIENT: {
                    return this.invokeRatisClient(method, args);
                }
            }
            return this.invokeRatisServer(method, args);
        }
        catch (Exception e) {
            throw SCMHAInvocationHandler.translateException(e);
        }
    }

    private Object invokeRatisServer(Method method, Object[] args) throws Exception {
        SCMRatisRequest scmRatisRequest = SCMRatisRequest.of(this.requestType, method.getName(), method.getParameterTypes(), args);
        SCMRatisResponse response = this.ratisHandler.submitRequest(scmRatisRequest);
        if (response.isSuccess()) {
            return response.getResult();
        }
        throw response.getException();
    }

    private Object invokeRatisClient(Method method, Object[] args) throws Exception {
        SCMRatisRequest scmRatisRequest = SCMRatisRequest.of(this.requestType, method.getName(), method.getParameterTypes(), args);
        SCMRatisResponse response = HASecurityUtils.submitScmRequestToRatis(this.ratisHandler.getDivision().getGroup(), this.ratisHandler.getGrpcTlsConfig(), scmRatisRequest.encode());
        if (response.isSuccess()) {
            return response.getResult();
        }
        throw response.getException();
    }

    private static SCMException translateException(Throwable t) {
        if (t instanceof SCMException) {
            return (SCMException)t;
        }
        if (t instanceof ExecutionException || t instanceof InvocationTargetException) {
            return SCMHAInvocationHandler.translateException(t.getCause());
        }
        SCMException.ResultCodes result = t instanceof TimeoutException ? SCMException.ResultCodes.TIMEOUT : (t instanceof NotLeaderException ? SCMException.ResultCodes.SCM_NOT_LEADER : (t instanceof IOException ? SCMException.ResultCodes.IO_EXCEPTION : SCMException.ResultCodes.INTERNAL_ERROR));
        return new SCMException(t, result);
    }
}

