/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocolPB;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.SecretKeyProtocol;
import org.apache.hadoop.hdds.protocol.SecretKeyProtocolScm;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecretKeyProtocolProtos;
import org.apache.hadoop.hdds.scm.proxy.SecretKeyProtocolFailoverProxyProvider;
import org.apache.hadoop.hdds.security.exception.SCMSecretKeyException;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;

public class SecretKeyProtocolClientSideTranslatorPB
implements SecretKeyProtocol,
SecretKeyProtocolScm,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final SCMSecretKeyProtocolProtos.SCMSecretKeyProtocolService.BlockingInterface rpcProxy;

    public SecretKeyProtocolClientSideTranslatorPB(SecretKeyProtocolFailoverProxyProvider<? extends SCMSecretKeyProtocolProtos.SCMSecretKeyProtocolService.BlockingInterface> proxyProvider, Class<? extends SCMSecretKeyProtocolProtos.SCMSecretKeyProtocolService.BlockingInterface> proxyClazz) {
        Preconditions.checkState((proxyProvider != null ? 1 : 0) != 0);
        SecretKeyProtocolFailoverProxyProvider<? extends SCMSecretKeyProtocolProtos.SCMSecretKeyProtocolService.BlockingInterface> failoverProxyProvider = proxyProvider;
        this.rpcProxy = (SCMSecretKeyProtocolProtos.SCMSecretKeyProtocolService.BlockingInterface)RetryProxy.create(proxyClazz, failoverProxyProvider, (RetryPolicy)failoverProxyProvider.getRetryPolicy());
    }

    private SCMSecretKeyProtocolProtos.SCMSecretKeyResponse submitRequest(SCMSecretKeyProtocolProtos.Type type, Consumer<SCMSecretKeyProtocolProtos.SCMSecretKeyRequest.Builder> builderConsumer) throws IOException {
        SCMSecretKeyProtocolProtos.SCMSecretKeyResponse response;
        try {
            SCMSecretKeyProtocolProtos.SCMSecretKeyRequest.Builder builder = SCMSecretKeyProtocolProtos.SCMSecretKeyRequest.newBuilder().setCmdType(type).setTraceID(TracingUtil.exportCurrentSpan());
            builderConsumer.accept(builder);
            SCMSecretKeyProtocolProtos.SCMSecretKeyRequest wrapper = builder.build();
            response = this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, wrapper);
            this.handleError(response);
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
        return response;
    }

    private SCMSecretKeyProtocolProtos.SCMSecretKeyResponse handleError(SCMSecretKeyProtocolProtos.SCMSecretKeyResponse resp) throws SCMSecretKeyException {
        if (resp.getStatus() != SCMSecretKeyProtocolProtos.Status.OK) {
            throw new SCMSecretKeyException(resp.getMessage(), SCMSecretKeyException.ErrorCode.values()[resp.getStatus().ordinal()]);
        }
        return resp;
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public ManagedSecretKey getCurrentSecretKey() throws IOException {
        SCMSecretKeyProtocolProtos.ManagedSecretKey secretKeyProto = this.submitRequest(SCMSecretKeyProtocolProtos.Type.GetCurrentSecretKey, builder -> {}).getCurrentSecretKeyResponseProto().getSecretKey();
        return ManagedSecretKey.fromProtobuf(secretKeyProto);
    }

    @Override
    public boolean checkAndRotate(boolean force) throws IOException {
        SCMSecretKeyProtocolProtos.SCMGetCheckAndRotateRequest request = SCMSecretKeyProtocolProtos.SCMGetCheckAndRotateRequest.newBuilder().setForce(force).build();
        boolean checkAndRotateStatus = this.submitRequest(SCMSecretKeyProtocolProtos.Type.CheckAndRotate, builder -> builder.setCheckAndRotateRequest(request)).getCheckAndRotateResponseProto().getStatus();
        return checkAndRotateStatus;
    }

    @Override
    public ManagedSecretKey getSecretKey(UUID id) throws IOException {
        SCMSecretKeyProtocolProtos.SCMGetSecretKeyRequest request = SCMSecretKeyProtocolProtos.SCMGetSecretKeyRequest.newBuilder().setSecretKeyId(HddsProtos.UUID.newBuilder().setMostSigBits(id.getMostSignificantBits()).setLeastSigBits(id.getLeastSignificantBits())).build();
        SCMSecretKeyProtocolProtos.SCMGetSecretKeyResponse response = this.submitRequest(SCMSecretKeyProtocolProtos.Type.GetSecretKey, builder -> builder.setGetSecretKeyRequest(request)).getGetSecretKeyResponseProto();
        return response.hasSecretKey() ? ManagedSecretKey.fromProtobuf(response.getSecretKey()) : null;
    }

    @Override
    public List<ManagedSecretKey> getAllSecretKeys() throws IOException {
        List secretKeysList = this.submitRequest(SCMSecretKeyProtocolProtos.Type.GetAllSecretKeys, builder -> {}).getSecretKeysListResponseProto().getSecretKeysList();
        return secretKeysList.stream().map(ManagedSecretKey::fromProtobuf).collect(Collectors.toList());
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

