/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.protocolPB;

import com.google.common.base.Preconditions;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicatedReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerListResult;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.OzonePBHelper;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.proxy.SCMContainerLocationFailoverProxyProvider;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.ozone.util.ProtobufUtils;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public final class StorageContainerLocationProtocolClientSideTranslatorPB
implements StorageContainerLocationProtocol,
ProtocolTranslator,
Closeable {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private final StorageContainerLocationProtocolPB rpcProxy;
    private final SCMContainerLocationFailoverProxyProvider fpp;

    public StorageContainerLocationProtocolClientSideTranslatorPB(SCMContainerLocationFailoverProxyProvider proxyProvider) {
        Preconditions.checkNotNull((Object)proxyProvider);
        this.fpp = proxyProvider;
        this.rpcProxy = (StorageContainerLocationProtocolPB)RetryProxy.create(StorageContainerLocationProtocolPB.class, (FailoverProxyProvider)this.fpp, (RetryPolicy)this.fpp.getRetryPolicy());
    }

    private StorageContainerLocationProtocolProtos.ScmContainerLocationResponse submitRequest(StorageContainerLocationProtocolProtos.Type type, Consumer<StorageContainerLocationProtocolProtos.ScmContainerLocationRequest.Builder> builderConsumer) throws IOException {
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response;
        try {
            StorageContainerLocationProtocolProtos.ScmContainerLocationRequest.Builder builder = StorageContainerLocationProtocolProtos.ScmContainerLocationRequest.newBuilder().setCmdType(type).setVersion(ClientVersion.CURRENT_VERSION).setTraceID(TracingUtil.exportCurrentSpan());
            builderConsumer.accept(builder);
            StorageContainerLocationProtocolProtos.ScmContainerLocationRequest wrapper = builder.build();
            response = this.submitRpcRequest(wrapper);
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
        return response;
    }

    private StorageContainerLocationProtocolProtos.ScmContainerLocationResponse submitRpcRequest(StorageContainerLocationProtocolProtos.ScmContainerLocationRequest wrapper) throws ServiceException {
        if (!ADMIN_COMMAND_TYPE.contains(wrapper.getCmdType())) {
            return this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, wrapper);
        }
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = null;
        for (StorageContainerLocationProtocolPB proxy : this.fpp.getProxies()) {
            response = proxy.submitRequest(NULL_RPC_CONTROLLER, wrapper);
        }
        return response;
    }

    @Override
    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        ReplicationConfig replicationConfig = ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)type, (HddsProtos.ReplicationFactor)factor);
        return this.allocateContainer(replicationConfig, owner);
    }

    @Override
    public ContainerWithPipeline allocateContainer(ReplicationConfig replicationConfig, String owner) throws IOException {
        StorageContainerLocationProtocolProtos.ContainerRequestProto.Builder request = StorageContainerLocationProtocolProtos.ContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setReplicationType(replicationConfig.getReplicationType()).setOwner(owner);
        if (replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC) {
            HddsProtos.ECReplicationConfig ecProto = ((ECReplicationConfig)replicationConfig).toProto();
            request.setEcReplicationConfig(ecProto);
            request.setReplicationFactor(HddsProtos.ReplicationFactor.ONE);
        } else {
            request.setReplicationFactor(HddsProtos.ReplicationFactor.valueOf((String)replicationConfig.getReplication()));
        }
        StorageContainerLocationProtocolProtos.ContainerResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.AllocateContainer, builder -> builder.setContainerRequest(request)).getContainerResponse();
        if (response.getErrorCode() != StorageContainerLocationProtocolProtos.ContainerResponseProto.Error.success) {
            throw new IOException(response.hasErrorMessage() ? response.getErrorMessage() : "Allocate container failed.");
        }
        return ContainerWithPipeline.fromProtobuf((HddsProtos.ContainerWithPipeline)response.getContainerWithPipeline());
    }

    @Override
    public ContainerInfo getContainer(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.GetContainerRequestProto request = StorageContainerLocationProtocolProtos.GetContainerRequestProto.newBuilder().setContainerID(containerID).setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainer, builder -> builder.setGetContainerRequest(request));
        return ContainerInfo.fromProtobuf((HddsProtos.ContainerInfoProto)response.getGetContainerResponse().getContainerInfo());
    }

    @Override
    public ContainerWithPipeline getContainerWithPipeline(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto request = StorageContainerLocationProtocolProtos.GetContainerWithPipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerWithPipeline, builder -> builder.setGetContainerWithPipelineRequest(request));
        return ContainerWithPipeline.fromProtobuf((HddsProtos.ContainerWithPipeline)response.getGetContainerWithPipelineResponse().getContainerWithPipeline());
    }

    @Override
    public List<HddsProtos.SCMContainerReplicaProto> getContainerReplicas(long containerID, int clientVersion) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.GetContainerReplicasRequestProto request = StorageContainerLocationProtocolProtos.GetContainerReplicasRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerReplicas, builder -> builder.setGetContainerReplicasRequest(request));
        return response.getGetContainerReplicasResponse().getContainerReplicaList();
    }

    @Override
    public List<ContainerWithPipeline> getContainerWithPipelineBatch(Iterable<? extends Long> containerIDs) throws IOException {
        for (Long l : containerIDs) {
            Preconditions.checkState((l >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        }
        StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchRequestProto request = StorageContainerLocationProtocolProtos.GetContainerWithPipelineBatchRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).addAllContainerIDs(containerIDs).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse scmContainerLocationResponse = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerWithPipelineBatch, builder -> builder.setGetContainerWithPipelineBatchRequest(request));
        List protoCps = scmContainerLocationResponse.getGetContainerWithPipelineBatchResponse().getContainerWithPipelinesList();
        ArrayList<ContainerWithPipeline> cps = new ArrayList<ContainerWithPipeline>();
        for (HddsProtos.ContainerWithPipeline cp : protoCps) {
            cps.add(ContainerWithPipeline.fromProtobuf((HddsProtos.ContainerWithPipeline)cp));
        }
        return cps;
    }

    @Override
    public List<ContainerWithPipeline> getExistContainerWithPipelinesInBatch(List<Long> containerIDs) {
        for (Long containerID : containerIDs) {
            Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        }
        StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchRequestProto request = StorageContainerLocationProtocolProtos.GetExistContainerWithPipelinesInBatchRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).addAllContainerIDs(containerIDs).build();
        StorageContainerLocationProtocolProtos.ScmContainerLocationResponse response = null;
        ArrayList<ContainerWithPipeline> cps = new ArrayList<ContainerWithPipeline>();
        try {
            response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetExistContainerWithPipelinesInBatch, builder -> builder.setGetExistContainerWithPipelinesInBatchRequest(request));
        }
        catch (IOException ex) {
            return cps;
        }
        List protoCps = response.getGetExistContainerWithPipelinesInBatchResponse().getContainerWithPipelinesList();
        for (HddsProtos.ContainerWithPipeline cp : protoCps) {
            cps.add(ContainerWithPipeline.fromProtobuf((HddsProtos.ContainerWithPipeline)cp));
        }
        return cps;
    }

    @Override
    public ContainerListResult listContainer(long startContainerID, int count) throws IOException {
        return this.listContainer(startContainerID, count, null, null, null);
    }

    @Override
    public ContainerListResult listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        return this.listContainer(startContainerID, count, state, null, null);
    }

    @Override
    public ContainerListResult listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state, HddsProtos.ReplicationType replicationType, ReplicationConfig replicationConfig) throws IOException {
        Preconditions.checkState((startContainerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative.");
        Preconditions.checkState((count > 0 ? 1 : 0) != 0, (Object)"Container count must be greater than 0.");
        StorageContainerLocationProtocolProtos.SCMListContainerRequestProto.Builder builder = StorageContainerLocationProtocolProtos.SCMListContainerRequestProto.newBuilder();
        builder.setStartContainerID(startContainerID);
        builder.setCount(count);
        builder.setTraceID(TracingUtil.exportCurrentSpan());
        if (state != null) {
            builder.setState(state);
        }
        if (replicationConfig != null) {
            if (replicationConfig.getReplicationType() == HddsProtos.ReplicationType.EC) {
                builder.setType(HddsProtos.ReplicationType.EC);
                builder.setEcReplicationConfig(((ECReplicationConfig)replicationConfig).toProto());
            } else {
                builder.setType(replicationConfig.getReplicationType());
                builder.setFactor(((ReplicatedReplicationConfig)replicationConfig).getReplicationFactor());
            }
        } else if (replicationType != null) {
            builder.setType(replicationType);
        }
        StorageContainerLocationProtocolProtos.SCMListContainerRequestProto request = builder.build();
        StorageContainerLocationProtocolProtos.SCMListContainerResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.ListContainer, builder1 -> builder1.setScmListContainerRequest(request)).getScmListContainerResponse();
        ArrayList<ContainerInfo> containerList = new ArrayList<ContainerInfo>();
        for (HddsProtos.ContainerInfoProto containerInfoProto : response.getContainersList()) {
            containerList.add(ContainerInfo.fromProtobuf((HddsProtos.ContainerInfoProto)containerInfoProto));
        }
        if (response.hasContainerCount()) {
            return new ContainerListResult(containerList, response.getContainerCount());
        }
        return new ContainerListResult(containerList, -1L);
    }

    @Override
    @Deprecated
    public ContainerListResult listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state, HddsProtos.ReplicationFactor factor) throws IOException {
        throw new UnsupportedOperationException("Should no longer be called from the client side");
    }

    @Override
    public void deleteContainer(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto request = StorageContainerLocationProtocolProtos.SCMDeleteContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.DeleteContainer, builder -> builder.setScmDeleteContainerRequest(request));
    }

    @Override
    public Map<String, List<ContainerID>> getContainersOnDecomNode(DatanodeDetails dn) throws IOException {
        StorageContainerLocationProtocolProtos.GetContainersOnDecomNodeRequestProto request = StorageContainerLocationProtocolProtos.GetContainersOnDecomNodeRequestProto.newBuilder().setDatanodeDetails(dn.getProtoBufMessage()).build();
        StorageContainerLocationProtocolProtos.GetContainersOnDecomNodeResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainersOnDecomNode, builder -> builder.setGetContainersOnDecomNodeRequest(request)).getGetContainersOnDecomNodeResponse();
        HashMap<String, List<ContainerID>> containerMap = new HashMap<String, List<ContainerID>>();
        for (StorageContainerLocationProtocolProtos.ContainersOnDecomNodeProto containersProto : response.getContainersOnDecomNodeList()) {
            ArrayList<ContainerID> containerIds = new ArrayList<ContainerID>();
            for (HddsProtos.ContainerID id : containersProto.getIdList()) {
                containerIds.add(ContainerID.getFromProtobuf((HddsProtos.ContainerID)id));
            }
            containerMap.put(containersProto.getName(), containerIds);
        }
        return containerMap;
    }

    @Override
    public List<HddsProtos.Node> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState nodeState, HddsProtos.QueryScope queryScope, String poolName, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.NodeQueryRequestProto.Builder builder = StorageContainerLocationProtocolProtos.NodeQueryRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setScope(queryScope).setPoolName(poolName);
        if (opState != null) {
            builder.setOpState(opState);
        }
        if (nodeState != null) {
            builder.setState(nodeState);
        }
        StorageContainerLocationProtocolProtos.NodeQueryRequestProto request = builder.build();
        StorageContainerLocationProtocolProtos.NodeQueryResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.QueryNode, builder1 -> builder1.setNodeQueryRequest(request)).getNodeQueryResponse();
        return response.getDatanodesList();
    }

    @Override
    public HddsProtos.Node queryNode(UUID uuid) throws IOException {
        StorageContainerLocationProtocolProtos.SingleNodeQueryRequestProto request = StorageContainerLocationProtocolProtos.SingleNodeQueryRequestProto.newBuilder().setUuid(ProtobufUtils.toProtobuf((UUID)uuid)).build();
        StorageContainerLocationProtocolProtos.SingleNodeQueryResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.SingleNodeQuery, builder -> builder.setSingleNodeQueryRequest(request)).getSingleNodeQueryResponse();
        return response.getDatanode();
    }

    @Override
    public List<DatanodeAdminError> decommissionNodes(List<String> nodes, boolean force) throws IOException {
        Preconditions.checkNotNull(nodes);
        StorageContainerLocationProtocolProtos.DecommissionNodesRequestProto request = StorageContainerLocationProtocolProtos.DecommissionNodesRequestProto.newBuilder().addAllHosts(nodes).setForce(force).build();
        StorageContainerLocationProtocolProtos.DecommissionNodesResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.DecommissionNodes, builder -> builder.setDecommissionNodesRequest(request)).getDecommissionNodesResponse();
        ArrayList<DatanodeAdminError> errors = new ArrayList<DatanodeAdminError>();
        for (StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto e : response.getFailedHostsList()) {
            errors.add(new DatanodeAdminError(e.getHost(), e.getError()));
        }
        return errors;
    }

    @Override
    public List<DatanodeAdminError> recommissionNodes(List<String> nodes) throws IOException {
        Preconditions.checkNotNull(nodes);
        StorageContainerLocationProtocolProtos.RecommissionNodesRequestProto request = StorageContainerLocationProtocolProtos.RecommissionNodesRequestProto.newBuilder().addAllHosts(nodes).build();
        StorageContainerLocationProtocolProtos.RecommissionNodesResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.RecommissionNodes, builder -> builder.setRecommissionNodesRequest(request)).getRecommissionNodesResponse();
        ArrayList<DatanodeAdminError> errors = new ArrayList<DatanodeAdminError>();
        for (StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto e : response.getFailedHostsList()) {
            errors.add(new DatanodeAdminError(e.getHost(), e.getError()));
        }
        return errors;
    }

    @Override
    public List<DatanodeAdminError> startMaintenanceNodes(List<String> nodes, int endInHours, boolean force) throws IOException {
        Preconditions.checkNotNull(nodes);
        StorageContainerLocationProtocolProtos.StartMaintenanceNodesRequestProto request = StorageContainerLocationProtocolProtos.StartMaintenanceNodesRequestProto.newBuilder().addAllHosts(nodes).setEndInHours((long)endInHours).setForce(force).build();
        StorageContainerLocationProtocolProtos.StartMaintenanceNodesResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.StartMaintenanceNodes, builder -> builder.setStartMaintenanceNodesRequest(request)).getStartMaintenanceNodesResponse();
        ArrayList<DatanodeAdminError> errors = new ArrayList<DatanodeAdminError>();
        for (StorageContainerLocationProtocolProtos.DatanodeAdminErrorResponseProto e : response.getFailedHostsList()) {
            errors.add(new DatanodeAdminError(e.getHost(), e.getError()));
        }
        return errors;
    }

    @Override
    public void closeContainer(long containerID) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative");
        StorageContainerLocationProtocolProtos.SCMCloseContainerRequestProto request = StorageContainerLocationProtocolProtos.SCMCloseContainerRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setContainerID(containerID).build();
        StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.CloseContainer, builder -> builder.setScmCloseContainerRequest(request)).getScmCloseContainerResponse();
        if (response.hasStatus() && (response.getStatus().equals((Object)StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.Status.CONTAINER_ALREADY_CLOSED) || response.getStatus().equals((Object)StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.Status.CONTAINER_ALREADY_CLOSING))) {
            String errorMessage = response.getStatus().equals((Object)StorageContainerLocationProtocolProtos.SCMCloseContainerResponseProto.Status.CONTAINER_ALREADY_CLOSED) ? String.format("Container %s already closed", containerID) : String.format("Container %s is in closing state", containerID);
            throw new IOException(errorMessage);
        }
    }

    @Override
    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        StorageContainerLocationProtocolProtos.PipelineRequestProto request = StorageContainerLocationProtocolProtos.PipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setNodePool(nodePool).setReplicationFactor(factor).setReplicationType(replicationType).build();
        StorageContainerLocationProtocolProtos.PipelineResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.AllocatePipeline, builder -> builder.setPipelineRequest(request)).getPipelineResponse();
        if (response.getErrorCode() == StorageContainerLocationProtocolProtos.PipelineResponseProto.Error.success) {
            Preconditions.checkState((boolean)response.hasPipeline(), (Object)"With success, must come a pipeline");
            return Pipeline.getFromProtobuf((HddsProtos.Pipeline)response.getPipeline());
        }
        String errorMessage = String.format("create replication pipeline failed. code : %s Message: %s", response.getErrorCode(), response.hasErrorMessage() ? response.getErrorMessage() : "");
        throw new IOException(errorMessage);
    }

    @Override
    public List<Pipeline> listPipelines() throws IOException {
        StorageContainerLocationProtocolProtos.ListPipelineRequestProto request = StorageContainerLocationProtocolProtos.ListPipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.ListPipelineResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.ListPipelines, builder -> builder.setListPipelineRequest(request)).getListPipelineResponse();
        ArrayList<Pipeline> list = new ArrayList<Pipeline>();
        for (HddsProtos.Pipeline pipeline : response.getPipelinesList()) {
            Pipeline fromProtobuf = Pipeline.getFromProtobuf((HddsProtos.Pipeline)pipeline);
            list.add(fromProtobuf);
        }
        return list;
    }

    @Override
    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.GetPipelineRequestProto request = StorageContainerLocationProtocolProtos.GetPipelineRequestProto.newBuilder().setPipelineID(pipelineID).setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.GetPipelineResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetPipeline, builder -> builder.setGetPipelineRequest(request)).getGetPipelineResponse();
        return Pipeline.getFromProtobuf((HddsProtos.Pipeline)response.getPipeline());
    }

    @Override
    public void activatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.ActivatePipelineRequestProto request = StorageContainerLocationProtocolProtos.ActivatePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.ActivatePipeline, builder -> builder.setActivatePipelineRequest(request));
    }

    @Override
    public void deactivatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.DeactivatePipelineRequestProto request = StorageContainerLocationProtocolProtos.DeactivatePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.DeactivatePipeline, builder -> builder.setDeactivatePipelineRequest(request));
    }

    @Override
    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        StorageContainerLocationProtocolProtos.ClosePipelineRequestProto request = StorageContainerLocationProtocolProtos.ClosePipelineRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).setPipelineID(pipelineID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.ClosePipeline, builder -> builder.setClosePipelineRequest(request));
    }

    @Override
    public ScmInfo getScmInfo() throws IOException {
        HddsProtos.GetScmInfoRequestProto request = HddsProtos.GetScmInfoRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).build();
        HddsProtos.GetScmInfoResponseProto resp = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetScmInfo, builder -> builder.setGetScmInfoRequest(request)).getGetScmInfoResponse();
        ScmInfo.Builder builder2 = new ScmInfo.Builder().setClusterId(resp.getClusterId()).setScmId(resp.getScmId()).setPeerRoles(resp.getPeerRolesList());
        return builder2.build();
    }

    @Override
    public void transferLeadership(String nodeId) throws IOException {
        HddsProtos.TransferLeadershipRequestProto.Builder reqBuilder = HddsProtos.TransferLeadershipRequestProto.newBuilder();
        reqBuilder.setNewLeaderId(nodeId);
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.TransferLeadership, builder -> builder.setTransferScmLeadershipRequest(reqBuilder.build()));
    }

    @Override
    @Deprecated
    public List<HddsProtos.DeletedBlocksTransactionInfo> getFailedDeletedBlockTxn(int count, long startTxId) throws IOException {
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public int resetDeletedBlockRetryCount(List<Long> txIDs) throws IOException {
        return 0;
    }

    @Override
    public boolean inSafeMode() throws IOException {
        StorageContainerLocationProtocolProtos.InSafeModeRequestProto request = StorageContainerLocationProtocolProtos.InSafeModeRequestProto.getDefaultInstance();
        return this.submitRequest(StorageContainerLocationProtocolProtos.Type.InSafeMode, builder -> builder.setInSafeModeRequest(request)).getInSafeModeResponse().getInSafeMode();
    }

    @Override
    public Map<String, Pair<Boolean, String>> getSafeModeRuleStatuses() throws IOException {
        StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesRequestProto request = StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.GetSafeModeRuleStatusesResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetSafeModeRuleStatuses, builder -> builder.setGetSafeModeRuleStatusesRequest(request)).getGetSafeModeRuleStatusesResponse();
        HashMap<String, Pair<Boolean, String>> map = new HashMap<String, Pair<Boolean, String>>();
        for (StorageContainerLocationProtocolProtos.SafeModeRuleStatusProto statusProto : response.getSafeModeRuleStatusesProtoList()) {
            map.put(statusProto.getRuleName(), (Pair<Boolean, String>)Pair.of((Object)statusProto.getValidate(), (Object)statusProto.getStatusText()));
        }
        return map;
    }

    @Override
    public boolean forceExitSafeMode() throws IOException {
        StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto request = StorageContainerLocationProtocolProtos.ForceExitSafeModeRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.ForceExitSafeModeResponseProto resp = this.submitRequest(StorageContainerLocationProtocolProtos.Type.ForceExitSafeMode, builder -> builder.setForceExitSafeModeRequest(request)).getForceExitSafeModeResponse();
        return resp.getExitedSafeMode();
    }

    @Override
    public void startReplicationManager() throws IOException {
        StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto request = StorageContainerLocationProtocolProtos.StartReplicationManagerRequestProto.getDefaultInstance();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.StartReplicationManager, builder -> builder.setStartReplicationManagerRequest(request));
    }

    @Override
    public void stopReplicationManager() throws IOException {
        StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto request = StorageContainerLocationProtocolProtos.StopReplicationManagerRequestProto.getDefaultInstance();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.StopReplicationManager, builder -> builder.setStopReplicationManagerRequest(request));
    }

    @Override
    public boolean getReplicationManagerStatus() throws IOException {
        StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto request = StorageContainerLocationProtocolProtos.ReplicationManagerStatusRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.ReplicationManagerStatusResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetReplicationManagerStatus, builder -> builder.setSeplicationManagerStatusRequest(request)).getReplicationManagerStatusResponse();
        return response.getIsRunning();
    }

    @Override
    public ReplicationManagerReport getReplicationManagerReport() throws IOException {
        StorageContainerLocationProtocolProtos.ReplicationManagerReportRequestProto request = StorageContainerLocationProtocolProtos.ReplicationManagerReportRequestProto.newBuilder().setTraceID(TracingUtil.exportCurrentSpan()).build();
        StorageContainerLocationProtocolProtos.ReplicationManagerReportResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetReplicationManagerReport, builder -> builder.setReplicationManagerReportRequest(request)).getGetReplicationManagerReportResponse();
        return ReplicationManagerReport.fromProtobuf((HddsProtos.ReplicationManagerReportProto)response.getReport());
    }

    @Override
    public StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto startContainerBalancer(Optional<Double> threshold, Optional<Integer> iterations, Optional<Integer> maxDatanodesPercentageToInvolvePerIteration, Optional<Long> maxSizeToMovePerIterationInGB, Optional<Long> maxSizeEnteringTargetInGB, Optional<Long> maxSizeLeavingSourceInGB, Optional<Integer> balancingInterval, Optional<Integer> moveTimeout, Optional<Integer> moveReplicationTimeout, Optional<Boolean> networkTopologyEnable, Optional<String> includeNodes, Optional<String> excludeNodes) throws IOException {
        StorageContainerLocationProtocolProtos.StartContainerBalancerRequestProto.Builder builder = StorageContainerLocationProtocolProtos.StartContainerBalancerRequestProto.newBuilder();
        builder.setTraceID(TracingUtil.exportCurrentSpan());
        if (threshold.isPresent()) {
            double tsd = threshold.get();
            Preconditions.checkState((tsd >= 0.0 && tsd < 100.0 ? 1 : 0) != 0, (Object)"Threshold should be specified in the range [0.0, 100.0).");
            builder.setThreshold(tsd);
        }
        if (maxSizeToMovePerIterationInGB.isPresent()) {
            long mstm = maxSizeToMovePerIterationInGB.get();
            Preconditions.checkState((mstm > 0L ? 1 : 0) != 0, (Object)"Max Size To Move Per Iteration In GB must be positive.");
            builder.setMaxSizeToMovePerIterationInGB(mstm);
        }
        if (maxDatanodesPercentageToInvolvePerIteration.isPresent()) {
            int mdti = maxDatanodesPercentageToInvolvePerIteration.get();
            Preconditions.checkState((mdti >= 0 ? 1 : 0) != 0, (Object)"Max Datanodes Percentage To Involve Per Iteration must be greater than equal to zero.");
            Preconditions.checkState((mdti <= 100 ? 1 : 0) != 0, (Object)"Max Datanodes Percentage To Involve Per Iteration must be lesser than equal to hundred.");
            builder.setMaxDatanodesPercentageToInvolvePerIteration(mdti);
        }
        if (iterations.isPresent()) {
            int i = iterations.get();
            Preconditions.checkState((i > 0 || i == -1 ? 1 : 0) != 0, (Object)"Number of Iterations must be positive or -1 (for running container balancer infinitely).");
            builder.setIterations(i);
        }
        if (maxSizeEnteringTargetInGB.isPresent()) {
            long mset = maxSizeEnteringTargetInGB.get();
            Preconditions.checkState((mset > 0L ? 1 : 0) != 0, (Object)"Max Size Entering Target In GB must be positive.");
            builder.setMaxSizeEnteringTargetInGB(mset);
        }
        if (maxSizeLeavingSourceInGB.isPresent()) {
            long msls = maxSizeLeavingSourceInGB.get();
            Preconditions.checkState((msls > 0L ? 1 : 0) != 0, (Object)"Max Size Leaving Source In GB must be positive.");
            builder.setMaxSizeLeavingSourceInGB(msls);
        }
        if (balancingInterval.isPresent()) {
            int bi = balancingInterval.get();
            Preconditions.checkState((bi > 0 ? 1 : 0) != 0, (Object)"Balancing Interval must be greater than zero.");
            builder.setBalancingInterval(bi);
        }
        if (moveTimeout.isPresent()) {
            int mt = moveTimeout.get();
            Preconditions.checkState((mt > 0 ? 1 : 0) != 0, (Object)"Move Timeout must be greater than zero.");
            builder.setMoveTimeout(mt);
        }
        if (moveReplicationTimeout.isPresent()) {
            int mrt = moveReplicationTimeout.get();
            Preconditions.checkState((mrt > 0 ? 1 : 0) != 0, (Object)"Move Replication Timeout must be greater than zero.");
            builder.setMoveReplicationTimeout(mrt);
        }
        if (networkTopologyEnable.isPresent()) {
            Boolean nt = networkTopologyEnable.get();
            builder.setNetworkTopologyEnable(nt.booleanValue());
        }
        if (includeNodes.isPresent()) {
            String in = includeNodes.get();
            builder.setIncludeNodes(in);
        }
        if (excludeNodes.isPresent()) {
            String ex = excludeNodes.get();
            builder.setExcludeNodes(ex);
        }
        StorageContainerLocationProtocolProtos.StartContainerBalancerRequestProto request = builder.build();
        return this.submitRequest(StorageContainerLocationProtocolProtos.Type.StartContainerBalancer, builder1 -> builder1.setStartContainerBalancerRequest(request)).getStartContainerBalancerResponse();
    }

    @Override
    public void stopContainerBalancer() throws IOException {
        StorageContainerLocationProtocolProtos.StopContainerBalancerRequestProto request = StorageContainerLocationProtocolProtos.StopContainerBalancerRequestProto.getDefaultInstance();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.StopContainerBalancer, builder -> builder.setStopContainerBalancerRequest(request));
    }

    @Override
    public boolean getContainerBalancerStatus() throws IOException {
        StorageContainerLocationProtocolProtos.ContainerBalancerStatusRequestProto request = StorageContainerLocationProtocolProtos.ContainerBalancerStatusRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.ContainerBalancerStatusResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerBalancerStatus, builder -> builder.setContainerBalancerStatusRequest(request)).getContainerBalancerStatusResponse();
        return response.getIsRunning();
    }

    @Override
    public StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoResponseProto getContainerBalancerStatusInfo() throws IOException {
        StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoRequestProto request = StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoRequestProto.getDefaultInstance();
        StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerBalancerStatusInfo, builder -> builder.setContainerBalancerStatusInfoRequest(request)).getContainerBalancerStatusInfoResponse();
        return response;
    }

    @Override
    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(String address, String uuid, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto request = StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto.newBuilder().setIpaddress(address).setUuid(uuid).build();
        StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.DatanodeUsageInfo, builder -> builder.setDatanodeUsageInfoRequest(request)).getDatanodeUsageInfoResponse();
        return response.getInfoList();
    }

    @Override
    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(boolean mostUsed, int count, int clientVersion) throws IOException {
        StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto request = StorageContainerLocationProtocolProtos.DatanodeUsageInfoRequestProto.newBuilder().setMostUsed(mostUsed).setCount(count).build();
        StorageContainerLocationProtocolProtos.DatanodeUsageInfoResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.DatanodeUsageInfo, builder -> builder.setDatanodeUsageInfoRequest(request)).getDatanodeUsageInfoResponse();
        return response.getInfoList();
    }

    @Override
    public UpgradeFinalization.StatusAndMessages finalizeScmUpgrade(String upgradeClientID) throws IOException {
        StorageContainerLocationProtocolProtos.FinalizeScmUpgradeRequestProto req = StorageContainerLocationProtocolProtos.FinalizeScmUpgradeRequestProto.newBuilder().setUpgradeClientId(upgradeClientID).build();
        StorageContainerLocationProtocolProtos.FinalizeScmUpgradeResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.FinalizeScmUpgrade, builder -> builder.setFinalizeScmUpgradeRequest(req)).getFinalizeScmUpgradeResponse();
        HddsProtos.UpgradeFinalizationStatus status = response.getStatus();
        return new UpgradeFinalization.StatusAndMessages(UpgradeFinalization.Status.valueOf((String)status.getStatus().name()), (Collection)status.getMessagesList());
    }

    @Override
    public UpgradeFinalization.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean force, boolean readonly) throws IOException {
        StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressRequestProto req = StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressRequestProto.newBuilder().setUpgradeClientId(upgradeClientID).setTakeover(force).setReadonly(readonly).build();
        StorageContainerLocationProtocolProtos.QueryUpgradeFinalizationProgressResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.QueryUpgradeFinalizationProgress, builder -> builder.setQueryUpgradeFinalizationProgressRequest(req)).getQueryUpgradeFinalizationProgressResponse();
        HddsProtos.UpgradeFinalizationStatus status = response.getStatus();
        return new UpgradeFinalization.StatusAndMessages(UpgradeFinalization.Status.valueOf((String)status.getStatus().name()), (Collection)status.getMessagesList());
    }

    @Override
    public Token<?> getContainerToken(ContainerID containerID) throws IOException {
        StorageContainerLocationProtocolProtos.GetContainerTokenRequestProto request = StorageContainerLocationProtocolProtos.GetContainerTokenRequestProto.newBuilder().setContainerID(containerID.getProtobuf()).build();
        StorageContainerLocationProtocolProtos.GetContainerTokenResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerToken, builder -> builder.setContainerTokenRequest(request)).getContainerTokenResponse();
        return OzonePBHelper.tokenFromProto((HddsProtos.TokenProto)response.getToken());
    }

    @Override
    public long getContainerCount() throws IOException {
        StorageContainerLocationProtocolProtos.GetContainerCountRequestProto request = StorageContainerLocationProtocolProtos.GetContainerCountRequestProto.newBuilder().build();
        StorageContainerLocationProtocolProtos.GetContainerCountResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetContainerCount, builder -> builder.setGetContainerCountRequest(request)).getGetContainerCountResponse();
        return response.getContainerCount();
    }

    @Override
    public long getContainerCount(HddsProtos.LifeCycleState state) throws IOException {
        StorageContainerLocationProtocolProtos.GetContainerCountRequestProto request = StorageContainerLocationProtocolProtos.GetContainerCountRequestProto.newBuilder().build();
        StorageContainerLocationProtocolProtos.GetContainerCountResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetClosedContainerCount, builder -> builder.setGetContainerCountRequest(request)).getGetContainerCountResponse();
        return response.getContainerCount();
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public List<ContainerInfo> getListOfContainers(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        return this.listContainer(startContainerID, count, state).getContainerInfoList();
    }

    @Override
    public StorageContainerLocationProtocolProtos.DecommissionScmResponseProto decommissionScm(String scmId) throws IOException {
        StorageContainerLocationProtocolProtos.DecommissionScmRequestProto request = StorageContainerLocationProtocolProtos.DecommissionScmRequestProto.newBuilder().setScmId(scmId).build();
        StorageContainerLocationProtocolProtos.DecommissionScmResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.DecommissionScm, builder -> builder.setDecommissionScmRequest(request)).getDecommissionScmResponse();
        return response;
    }

    @Override
    public String getMetrics(String query) throws IOException {
        StorageContainerLocationProtocolProtos.GetMetricsRequestProto request = StorageContainerLocationProtocolProtos.GetMetricsRequestProto.newBuilder().setQuery(query).build();
        StorageContainerLocationProtocolProtos.GetMetricsResponseProto response = this.submitRequest(StorageContainerLocationProtocolProtos.Type.GetMetrics, builder -> builder.setGetMetricsRequest(request)).getGetMetricsResponse();
        String metricsJsonStr = response.getMetricsJson();
        return metricsJsonStr;
    }

    @Override
    public void reconcileContainer(long containerID) throws IOException {
        StorageContainerLocationProtocolProtos.ReconcileContainerRequestProto request = StorageContainerLocationProtocolProtos.ReconcileContainerRequestProto.newBuilder().setContainerID(containerID).build();
        this.submitRequest(StorageContainerLocationProtocolProtos.Type.ReconcileContainer, builder -> builder.setReconcileContainerRequest(request));
    }
}

