/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.symmetric.SecretKeyVerifierClient;
import org.apache.hadoop.hdds.security.token.ContainerTokenIdentifier;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenVerifier;

public class ContainerTokenVerifier
extends ShortLivedTokenVerifier<ContainerTokenIdentifier> {
    public ContainerTokenVerifier(SecurityConfig conf, SecretKeyVerifierClient secretKeyClient) {
        super(conf, secretKeyClient);
    }

    @Override
    protected boolean isTokenRequired(ContainerProtos.Type cmdType) {
        return this.getConf().isContainerTokenEnabled() && HddsUtils.requireContainerToken((ContainerProtos.Type)cmdType);
    }

    @Override
    protected ContainerTokenIdentifier createTokenIdentifier() {
        return new ContainerTokenIdentifier();
    }

    @Override
    protected Object getService(ContainerProtos.ContainerCommandRequestProtoOrBuilder cmd) {
        return ContainerID.valueOf((long)cmd.getContainerID());
    }
}

