/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Name;
import org.jooq.Param;
import org.jooq.ParamMode;
import org.jooq.UDTRecord;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.tools.StringUtils;

abstract class AbstractParam<T>
extends AbstractField<T>
implements Param<T> {
    private static final long serialVersionUID = 1311856649676227970L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD, Clause.FIELD_VALUE};
    private final String paramName;
    T value;
    private boolean inline;

    AbstractParam(T value, DataType<T> type) {
        this(value, type, null);
    }

    AbstractParam(T value, DataType<T> type, String paramName) {
        super(AbstractParam.name(value, paramName), type);
        this.paramName = paramName;
        this.value = value;
    }

    static Name name(Object value, String paramName) {
        return DSL.name(paramName != null ? paramName : (value instanceof UDTRecord ? ((UDTRecord)value).getUDT().getName() : String.valueOf(value)));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final boolean generatesCast() {
        return true;
    }

    @Override
    public final void setValue(T value) {
        this.setConverted(value);
    }

    @Override
    public final void setConverted(Object value) {
        this.value = this.getDataType().convert(value);
    }

    @Override
    public final T getValue() {
        return this.value;
    }

    @Override
    public final String getParamName() {
        return this.paramName;
    }

    @Override
    public final void setInline(boolean inline) {
        this.inline = inline;
    }

    @Override
    public final boolean isInline() {
        return this.inline;
    }

    final boolean isInline(Context<?> context) {
        return this.isInline() || context.paramType() == ParamType.INLINED || context.paramType() == ParamType.NAMED_OR_INLINED && StringUtils.isBlank(this.paramName);
    }

    @Override
    public final ParamType getParamType() {
        return this.inline ? ParamType.INLINED : (StringUtils.isBlank(this.paramName) ? ParamType.INDEXED : ParamType.NAMED);
    }

    @Override
    public final ParamMode getParamMode() {
        return ParamMode.IN;
    }

    @Override
    public void accept(Context<?> ctx) {
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof AbstractParam) {
            AbstractParam thatParam = (AbstractParam)that;
            if (this.value == null) {
                return thatParam.value == null;
            }
            if (this.value instanceof byte[] && thatParam.value instanceof byte[]) {
                return Arrays.equals((byte[])this.value, (byte[])thatParam.value);
            }
            if (this.value instanceof Object[] && thatParam.value instanceof Object[]) {
                return Arrays.equals((Object[])this.value, (Object[])thatParam.value);
            }
            return this.value.equals(thatParam.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value == null ? 0 : (this.value instanceof byte[] ? Arrays.hashCode((byte[])this.value) : (this.value instanceof Object[] ? Arrays.hashCode((Object[])this.value) : this.value.hashCode()));
    }
}

