/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.compaction.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.ozone.compaction.log.SstFileInfo;
import org.rocksdb.LiveFileMetaData;

public final class CompactionFileInfo
extends SstFileInfo {
    private boolean pruned;

    @VisibleForTesting
    public CompactionFileInfo(String fileName, String startRange, String endRange, String columnFamily) {
        this(fileName, startRange, endRange, columnFamily, false);
    }

    public CompactionFileInfo(String fileName, String startRange, String endRange, String columnFamily, boolean pruned) {
        super(fileName, startRange, endRange, columnFamily);
        this.pruned = pruned;
    }

    public boolean isPruned() {
        return this.pruned;
    }

    public void setPruned() {
        this.pruned = true;
    }

    public HddsProtos.CompactionFileInfoProto getProtobuf() {
        HddsProtos.CompactionFileInfoProto.Builder builder = HddsProtos.CompactionFileInfoProto.newBuilder().setFileName(this.getFileName()).setPruned(this.pruned);
        if (this.getStartKey() != null) {
            builder = builder.setStartKey(this.getStartKey());
        }
        if (this.getEndKey() != null) {
            builder = builder.setEndKey(this.getEndKey());
        }
        if (this.getColumnFamily() != null) {
            builder = builder.setColumnFamily(this.getColumnFamily());
        }
        return builder.build();
    }

    public static CompactionFileInfo getFromProtobuf(HddsProtos.CompactionFileInfoProto proto) {
        Builder builder = new Builder(proto.getFileName());
        if (proto.hasStartKey()) {
            builder.setStartRange(proto.getStartKey());
        }
        if (proto.hasEndKey()) {
            builder.setEndRange(proto.getEndKey());
        }
        if (proto.hasColumnFamily()) {
            builder.setColumnFamily(proto.getColumnFamily());
        }
        if (proto.hasPruned() && proto.getPruned()) {
            builder.setPruned();
        }
        return builder.build();
    }

    @Override
    public String toString() {
        return String.format("%s, isPruned: '%b'", super.toString(), this.pruned);
    }

    @Override
    public SstFileInfo copyObject() {
        return new CompactionFileInfo(this.getFileName(), this.getStartKey(), this.getEndKey(), this.getColumnFamily(), this.pruned);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CompactionFileInfo)) {
            return false;
        }
        return super.equals(o) && this.pruned == ((CompactionFileInfo)o).pruned;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pruned);
    }

    public static class Builder {
        private final String fileName;
        private String startRange;
        private String endRange;
        private String columnFamily;
        private boolean pruned = false;

        public Builder(String fileName) {
            Preconditions.checkNotNull((Object)fileName, (Object)"FileName is required parameter.");
            this.fileName = fileName;
        }

        public Builder setStartRange(String startRange) {
            this.startRange = startRange;
            return this;
        }

        public Builder setEndRange(String endRange) {
            this.endRange = endRange;
            return this;
        }

        public Builder setColumnFamily(String columnFamily) {
            this.columnFamily = columnFamily;
            return this;
        }

        public Builder setValues(LiveFileMetaData fileMetaData) {
            if (fileMetaData != null) {
                String columnFamilyName = StringUtils.bytes2String((byte[])fileMetaData.columnFamilyName());
                String startRangeValue = StringUtils.bytes2String((byte[])fileMetaData.smallestKey());
                String endRangeValue = StringUtils.bytes2String((byte[])fileMetaData.largestKey());
                this.setColumnFamily(columnFamilyName).setStartRange(startRangeValue).setEndRange(endRangeValue);
            }
            return this;
        }

        public Builder setPruned() {
            this.pruned = true;
            return this;
        }

        public CompactionFileInfo build() {
            if (!(this.startRange == null && this.endRange == null && this.columnFamily == null || this.startRange != null && this.endRange != null && this.columnFamily != null)) {
                throw new IllegalArgumentException(String.format("Either all of startRange, endRange and columnFamily should be non-null or null. startRange: '%s', endRange: '%s', columnFamily: '%s'.", this.startRange, this.endRange, this.columnFamily));
            }
            return new CompactionFileInfo(this.fileName, this.startRange, this.endRange, this.columnFamily, this.pruned);
        }
    }
}

