/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.SAXParserFactory;
import org.apache.hadoop.ozone.s3.endpoint.XmlNamespaceFilter;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.util.S3Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class MessageUnmarshaller<T>
implements MessageBodyReader<T> {
    private final JAXBContext context;
    private final SAXParserFactory saxParserFactory;
    private final Class<T> cls;

    public MessageUnmarshaller(Class<T> cls) {
        this.cls = cls;
        try {
            this.context = JAXBContext.newInstance((Class[])new Class[]{cls});
            this.saxParserFactory = SAXParserFactory.newInstance();
            this.saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception ex) {
            throw new AssertionError("Can not instantiate XML parser for " + cls.getSimpleName(), ex);
        }
    }

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return type.equals(this.cls);
    }

    public T readFrom(Class<T> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) throws WebApplicationException {
        try {
            XMLReader xmlReader = this.saxParserFactory.newSAXParser().getXMLReader();
            UnmarshallerHandler unmarshallerHandler = this.context.createUnmarshaller().getUnmarshallerHandler();
            XmlNamespaceFilter filter = new XmlNamespaceFilter("http://s3.amazonaws.com/doc/2006-03-01/");
            filter.setContentHandler((ContentHandler)unmarshallerHandler);
            filter.setParent(xmlReader);
            filter.parse(new InputSource(inputStream));
            return this.cls.cast(unmarshallerHandler.getResult());
        }
        catch (Exception e) {
            throw S3Utils.wrapOS3Exception(S3ErrorTable.INVALID_REQUEST.withMessage(e.getMessage()));
        }
    }

    public T readFrom(InputStream inputStream) throws WebApplicationException {
        return this.readFrom(this.cls, this.cls, new Annotation[0], MediaType.APPLICATION_XML_TYPE, null, inputStream);
    }
}

