/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3secret;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.s3secret.S3SecretEnabled;

@S3SecretEnabled
@Provider
public class S3SecretEnabledEndpointRequestFilter
implements ContainerRequestFilter {
    @Inject
    private OzoneConfiguration ozoneConfiguration;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        boolean isSecretEnabled = this.ozoneConfiguration.getBoolean("ozone.s3g.secret.http.enabled", false);
        if (!isSecretEnabled) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"S3 Secret endpoint is disabled.").build());
        }
    }
}

